<?php

if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Slider Template
 * Displays posts with a tag (specified in theme options) in a format usable with flexslider
 *
 * @see woo_slider()
 */

$woo_featured_tags = get_option( 'woo_featured_tags' );

if ( ( '' != $woo_featured_tags ) && ( isset( $woo_featured_tags ) ) ) {
	$featposts 					= get_option( 'woo_featured_entries' ); // Number of featured entries to be shown
	$GLOBALS['feat_tags_array'] = explode( ',', get_option( 'woo_featured_tags' ) ); // Tags to be shown

	$tag_array = array();
	foreach ( $GLOBALS['feat_tags_array'] as $tags ) {
		$tag = get_term_by( 'name', trim( $tags ), 'post_tag', 'ARRAY_A' );

		if ( isset( $tag['term_id'] ) && absint( $tag['term_id'] ) > 0 ) {
			$tag_array[] = absint( $tag['term_id'] );
		} // End If Statement
	} // End For Loop

	// The Query
	$query_args['posts_per_page'] 	= $featposts;
	if ( isset( $tag_array ) && !empty( $tag_array) ) {
		$query_args['tag__in'] 			= $tag_array;
	} // End If Statement
	$the_query 						= new WP_Query($query_args);

	$posts_to_exclude = array();

	if ( isset( $tag_array ) && !empty( $tag_array) ) {

		if ( $the_query->have_posts() ) {
			$count = 0;
			?>
			<div id="home-slider" class="flexslider">
				<ul class="slides">
				<?php
				while ( $the_query->have_posts() ) {
					$the_query->the_post();
					array_push( $posts_to_exclude, get_the_ID() ); ?>
					<li>
				      	<a href="<?php the_permalink() ?>" rel="bookmark" title="<?php the_title(); ?>" class="slide-link">
					      	<?php
					    	if ( has_post_thumbnail() ) {
					    		the_post_thumbnail( 'large' );
					    	} elseif( woo_image( 'return=true' ) ) {
					    		woo_image( array( 'noheight' => 'true', 'link' => 'img' ) );
					    	} // End If Statement
					      	?>
					      	<div class="slide-content">

		       		     		<div><h2><?php the_title(); ?></h2></div>

		       		     		<p><?php echo woo_excerpt( get_the_excerpt(), '150' ); ?></p>

		       		 		</div><!-- /.slide-content -->
	       		 		</a>
				    </li>
				<?php } // End While Loop ?>
				</ul>
			</div><!-- #home-slider .flexslider -->
			<?php
		} // End If Statement

		wp_reset_postdata();

		$slider_transient = get_transient( 'woo_slider_query_exclusions' );
		if ( empty( $slider_transient ) || ( $posts_to_exclude !== $slider_transient ) ){
		   // we have a transient return/assign the results
		   set_transient( 'woo_slider_query_exclusions', $posts_to_exclude, 12 * HOUR_IN_SECONDS );
		} // End If Statement

	} // End If Statement

} else {

	echo do_shortcode( '[box type="note"]' . __( 'Please enter some tags in the Theme Options panel in order to view slides on the homepage.', 'woothemes' ) . '[/box]' );

} // End If Statement