<?php
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Theme Template
 *
 * Functions used by the theme to display template components
 *
 * @since   1.0.0
 * @author 	WooThemes
 */

/**
 * Display breadcrumbs.
 *
 * Display breadcrumbs on all pages except the homepage unless specified otherwise via woo_breadcrumbs filter.
 *
 * @since  	1.0.0
 * @return 	void
 * @uses  	woo_breadcrumbs()
 * @link 	http://docs.woothemes.com/document/woo_breadcrumbs/
 * @author 	WooThemes
 */
if ( ! function_exists( 'woo_display_breadcrumbs' ) ) {
	function woo_display_breadcrumbs() {
		if ( apply_filters( 'woo_breadcrumbs', true ) && ! is_home() ) {
		echo '<section id="breadcrumbs">';
			woo_breadcrumbs();
		echo '</section><!--/#breadcrumbs -->';
		}
	} // End woo_display_breadcrumbs()
} // End IF Statement
add_action( 'woo_main_before', 'woo_display_breadcrumbs', 10 );

/**
 * Post meta.
 *
 * Display post date, author, category and comments.
 *
 * @since 	1.0.0
 * @uses 	the_time(), get_option(), the_author_posts_link(), the_category(), comments_popup_link()
 * @return  void
 * @author 	WooThemes
 */
if ( ! function_exists( 'woo_post_meta' ) ) {
	function woo_post_meta() {
		?>
		<aside class="post-meta">
			<ul>
				<li class="post-author">
					<?php echo get_avatar( get_the_author_meta( 'email' ) , '256' ); ?>
					<span><?php _e( 'by ', 'woothemes' ) . the_author_posts_link(); ?></span>
				</li>
				<li class="post-date">
					<span><?php echo human_time_diff( get_the_time( 'U' ), current_time( 'timestamp' ) ) . __( ' ago', 'woothemes' ); ?></span>
				</li>
				<li class="post-category">
					<?php
						echo '<span>' . __( 'Posted in', 'woothemes' ) . '</span>';
						the_category( ', ');
					?>
				</li>
				<li class="comments">
					<?php
						echo '<span>' . __( 'There are', 'woothemes' ) . '</span>';
						comments_popup_link( __( 'No comments', 'woothemes' ), __( '1 comment', 'woothemes' ), __( '% comments', 'woothemes' ) );
					?>
				</li>
				<?php the_tags( '<li class="tags"><span>' . __( 'Tagged', 'woothemes' ) . '</span>', ', ', '</li>' ); ?>
			</ul>
		</aside>
		<?php
	}
}

/**
 * Post meta (archive).
 *
 * Display post date, author, category and comments.
 *
 * @since 	1.0.0
 * @uses 	the_time(), get_option(), the_author_posts_link(), the_category(), comments_popup_link()
 * @return  void
 * @author 	WooThemes
 */
if ( ! function_exists( 'woo_post_meta_archive' ) ) {
	function woo_post_meta_archive() {
		?>
		<aside class="post-meta">
			<ul>
				<li class="post-date">
					<span><?php echo human_time_diff( get_the_time( 'U' ), current_time( 'timestamp' ) ) . __( ' ago', 'woothemes' ); ?></span>
				</li>
				<li class="post-category">
					<?php the_category( ', ') ?>
				</li>
			</ul>
		</aside>
		<?php
	}
}

/**
 * Archive Description.
 *
 * Display a description, if available, for the archive being viewed (category, tag, other taxonomy).
 *
 * @since 	1.0.0
 * @uses 	do_atomic(), get_queried_object(), term_description()
 * @return  string
 * @author 	WooThemes
 */
if ( ! function_exists( 'woo_archive_description' ) ) {
	function woo_archive_description ( $echo = true ) {
		do_action( 'woo_archive_description' );

		// Archive Description, if one is available.
		$description = '';

		if ( ! is_post_type_archive() ) {

			if ( get_queried_object() != null ) {
				$term_obj 		= get_queried_object();
				$description 	= term_description( $term_obj->term_id, $term_obj->taxonomy );
			} else {
				$description 	= '';
			}

		}

		if ( $description != '' ) {
			// Allow child themes/plugins to filter here ( 1: text in DIV and paragraph, 2: term object )
			$description = apply_filters( 'woo_archive_description', '<div class="archive-description">' . $description . '</div><!--/.archive-description-->', $term_obj );
		}

		if ( $echo != true ) { return $description; }

		echo $description;
	} // End woo_archive_description()
}

/**
 * Top Navigation.
 *
 * Display the top navigation if a menu is set.
 *
 * @since  	1.0.0
 * @return 	void
 * @uses  	wp_nav_menu()
 * @author 	WooThemes
 */
if ( ! function_exists( 'woo_top_nav' ) ) {
	function woo_top_nav () {
		if ( function_exists( 'has_nav_menu' ) && has_nav_menu( 'top-menu' ) ) {
		?>
		<div id="top">
			<nav class="col-full" role="navigation">
				<div class="top-navigation">
					<?php
						echo '<h3>' . woo_get_menu_name( 'top-menu' ) . '</h3>';
						wp_nav_menu(
							array(
								'depth' 			=> 6,
								'sort_column' 		=> 'menu_order',
								'container' 		=> 'ul',
								'menu_id' 			=> 'top-nav',
								'menu_class' 		=> 'nav',
								'theme_location' 	=> 'top-menu',
								)
							);
					?>
				</div><!--/.top-navigation-->
			</nav><!--/.col-full-->
		</div><!-- /#top -->
	 	<?php
		}
	} // End woo_top_nav()
}

/**
 * Display logo.
 *
 * Display a custom logo if specified in the Theme Options.
 *
 * @since  	1.0.0
 * @return 	void
 * @uses  	global $woo_options array of Theme Options
 * @author 	WooThemes
 */
if ( ! function_exists( 'woo_logo' ) ) {
	function woo_logo () {
		global $woo_options;
		if ( isset( $woo_options['woo_texttitle'] ) && $woo_options['woo_texttitle'] == 'true' ) return; // Get out if we're not displaying the logo.

		$logo = esc_url( get_template_directory_uri() . '/images/logo.png' );
		if ( isset( $woo_options['woo_logo'] ) && $woo_options['woo_logo'] != '' ) { $logo = $woo_options['woo_logo']; }
		if ( is_ssl() ) { $logo = str_replace( 'http://', 'https://', $logo ); }
	?>
		<a id="logo" href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'description' ) ); ?>">
			<img src="<?php echo esc_url( $logo ); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name' ) ); ?>" />
		</a>
	<?php
	} // End woo_logo()
}

/**
 * Google Map.
 *
 * Displays the Google map on the contact template
 *
 * @since  	1.0.0
 * @return 	void
 * @param   array $args Theme settings
 * @author 	WooThemes
 */
function woo_maps_contact_output( $args ) {

	$key = get_option( 'woo_maps_apikey' );

	// No More API Key needed

	if ( ! is_array( $args ) )
		parse_str( $args, $args );

	extract( $args );
	$mode 			= '';
	$streetview 	= 'off';
	$map_height 	= apply_filters( 'woo_maps_height', 250 );
	$featured_w 	= get_option( 'woo_home_featured_w' );
	$featured_h 	= get_option( 'woo_home_featured_h' );
	$zoom 			= apply_filters( 'woo_maps_zoom', 9 );
	$type 			= apply_filters( 'woo_maps_type', 'G_NORMAL_MAP' );
	$marker_title 	= get_option( 'woo_contact_title' );

	if ( $zoom == '' ) {
		$zoom = 6;
	}

	$lang 			= get_option( 'woo_maps_directions_locale' );
	$locale 		= '';

	if ( ! empty( $lang ) ) {
		$locale 	= ',locale :"'.$lang.'"';
	}

	$extra_params 	= ',{travelMode:G_TRAVEL_MODE_WALKING,avoidHighways:true '.$locale.'}';

	if ( empty( $map_height ) ) {
		$map_height = 250;
	}

	if ( is_home() && ! empty( $featured_h ) && ! empty( $featured_w ) ) {

	?>

    <div id="single_map_canvas" style="width:<?php echo $featured_w; ?>px; height: <?php echo $featured_h; ?>px"></div>

    <?php } else { ?>

    <div id="single_map_canvas" style="width:100%; height: <?php echo $map_height; ?>px"></div>

    <?php } ?>

    <script type="text/javascript">
		jQuery( document ).ready( function(){
			function initialize() {

			<?php if ( $streetview == 'on' ) { ?>

			<?php } else { ?>

			  	<?php switch ( $type ) {
			  			case 'G_NORMAL_MAP':
			  				$type = 'ROADMAP';
			  				break;
			  			case 'G_SATELLITE_MAP':
			  				$type = 'SATELLITE';
			  				break;
			  			case 'G_HYBRID_MAP':
			  				$type = 'HYBRID';
			  				break;
			  			case 'G_PHYSICAL_MAP':
			  				$type = 'TERRAIN';
			  				break;
			  			default:
			  				$type = 'ROADMAP';
			  				break;
			  	} ?>

			  	var myLatlng 	= new google.maps.LatLng(<?php echo $geocoords; ?>);
				var myOptions 	= {
				  zoom: <?php echo $zoom; ?>,
				  center: myLatlng,
				  mapTypeId: google.maps.MapTypeId.<?php echo $type; ?>
				};
				<?php if ( apply_filters( 'woo_maps_scroll', true ) ){ ?>
			  	myOptions.scrollwheel = true;
			  	<?php } ?>
			  	var map = new google.maps.Map(document.getElementById("single_map_canvas"),  myOptions);

				<?php if ( $mode == 'directions' ) { ?>
			  	directionsPanel = document.getElementById( "featured-route" );
 				directions 		= new GDirections( map, directionsPanel );
  				directions.load( "from: <?php echo $from; ?> to: <?php echo $to; ?>" <?php if ( $walking == 'on' ) { echo $extra_params; } ?>);

			  	<?php } else { ?>

			  		var point 		= new google.maps.LatLng(<?php echo $geocoords; ?>);
	  				var root 		= "<?php echo esc_url( get_template_directory_uri() ); ?>";
	  				var callout 	= '<?php echo preg_replace("/[\n\r]/","<br/>",get_option( 'woo_maps_callout_text' ) ); ?>';
	  				var the_link 	= '<?php echo get_permalink(get_the_id()); ?>';
	  				<?php
	  				$title 			= str_replace( array(
	  												'&#8220;',
	  												'&#8221;'
	  												),
	  												'"', $marker_title );
	  				$title 			= str_replace( '&#8211;', '-', $title );
	  				$title 			= str_replace( '&#8217;', "`", $title );
	  				$title 			= str_replace( '&#038;', '&', $title );
	  				?>
	  				var the_title 	= '<?php echo html_entity_decode( $title ) ?>';

	  			<?php
			 	if ( is_page() ) {
			 		$custom = get_option( 'woo_cat_custom_marker_pages' );
					if ( ! empty( $custom ) ) {
						$color = $custom;
					}
					else {
						$color = get_option( 'woo_cat_colors_pages' );
						if ( empty( $color ) ) {
							$color = 'red';
						}
					}
			 	?>
			 		var color = '<?php echo $color; ?>';
			 		createMarker( map,point,root,the_link,the_title,color,callout );
			 	<?php } else { ?>
			 		var color = '<?php echo get_option( 'woo_cat_colors_pages' ); ?>';
	  				createMarker( map,point,root,the_link,the_title,color,callout );
				<?php
				}
					if ( isset( $_POST['woo_maps_directions_search'] ) ) { ?>

					directionsPanel = document.getElementById( "featured-route" );
 					directions 		= new GDirections(map, directionsPanel);
  					directions.load( "from: <?php echo htmlspecialchars($_POST['woo_maps_directions_search']); ?> to: <?php echo $address; ?>" <?php if ( $walking == 'on' ) { echo $extra_params;} ?>);



					directionsDisplay = new google.maps.DirectionsRenderer();
					directionsDisplay.setMap( map );
    				directionsDisplay.setPanel( document.getElementById( "featured-route" ) );

					<?php if ( $walking == 'on' ) { ?>
					var travelmodesetting = google.maps.DirectionsTravelMode.WALKING;
					<?php } else { ?>
					var travelmodesetting = google.maps.DirectionsTravelMode.DRIVING;
					<?php } ?>
					var start 	= '<?php echo htmlspecialchars( $_POST['woo_maps_directions_search'] ); ?>';
					var end 	= '<?php echo $address; ?>';
					var request = {
       					origin:start,
        				destination:end,
        				travelMode: travelmodesetting
    				};
    				directionsService.route(request, function(response, status) {
      					if (status == google.maps.DirectionsStatus.OK) {
        					directionsDisplay.setDirections(response);
      					}
      				});

  					<?php } ?>
				<?php } ?>
			<?php } ?>


			}
			function handleNoFlash( errorCode ) {
				if ( errorCode == FLASH_UNAVAILABLE ) {
					alert( "Error: Flash doesn't appear to be supported by your browser" );
					return;
				}
			}

		initialize();

		});
	jQuery( window ).load( function(){

		var newHeight 	= jQuery( '#featured-content' ).height();
		newHeight 		= newHeight - 5;
		if( newHeight > 300 ) {
			jQuery( '#single_map_canvas' ).height( newHeight );
		}

	});

	</script>

<?php
}

/**
 * Single Post Navigation.
 *
 * Provides links to next / previous posts.
 *
 * @since  	1.0.0
 * @return 	void
 * @uses  	previous_post_link(), next_post_link()
 * @author 	WooThemes
 */
if ( ! function_exists( 'woo_single_post_nav' ) ) {
	function woo_single_post_nav() {
		if ( is_single() ) {
		?>
		<nav id="post-entries" class="fix">
	        <div class="nav-prev fl"><?php previous_post_link( '%link', '%title' ); ?></div>
	        <div class="nav-next fr"><?php next_post_link( '%link', '%title' ); ?></div>
	    </nav><!-- #post-entries -->
		<?php
		}
	}
}

/**
 * Display Recent Products.
 *
 * Calls a template file to display recent products in WooCommerce.
 *
 * @since  	1.0.0
 * @return 	void
 * @uses  	get_template_part()
 * @link 	http://www.woothemes.com/woocommerce/
 * @author 	WooThemes
 */
function woo_display_recent_products() {
	get_template_part( 'includes/integrations/woocommerce/template-recent-products' );
}

/**
 * Display WooSlider.
 *
 * Calls a template file to display slideshows as defined in the WooSlider plugin.
 *
 * @since  	1.0.0
 * @return 	void
 * @uses  	get_template_part()
 * @link 	http://www.woothemes.com/products/wooslider/
 * @author 	WooThemes
 */
function woo_display_wooslider() {
	get_template_part( 'includes/integrations/wooslider/template-wooslider' );
}

/**
 * Display Testimonials.
 *
 * Calls a template file to display features as defined in the Testimonials by WooThemes plugin.
 *
 * @since  	1.0.0
 * @return 	void
 * @uses  	get_template_part()
 * @link 	http://wordpress.org/plugins/testimonials-by-woothemes/
 * @author 	WooThemes
 */
function woo_display_testimonials() {
	get_template_part( 'includes/integrations/testimonials/template-testimonials' );
}

/**
 * Display Features.
 *
 * Calls a template file to display features as defined in the Features by WooThemes plugin.
 *
 * @since  	1.0.0
 * @return 	void
 * @uses  	get_template_part()
 * @link 	http://wordpress.org/plugins/features-by-woothemes/
 * @author 	WooThemes
 */
function woo_display_features() {
	get_template_part( 'includes/integrations/features/template-features' );
}

/**
 * Display Team Members.
 *
 * Calls a template file to display team members as defined in the Our Team plugin.
 *
 * @since  	1.0.0
 * @return 	void
 * @uses  	get_template_part()
 * @link 	http://wordpress.org/plugins/our-team-by-woothemes/
 * @author 	WooThemes
 */
function woo_display_our_team() {
	get_template_part( 'includes/integrations/our-team/template-our-team' );
}

/**
 * Display Recent Projects.
 *
 * Calls a template file to display projects as defined in the Projects plugin.
 *
 * @since  	1.0.0
 * @return 	void
 * @uses  	get_template_part()
 * @link 	http://wordpress.org/plugins/our-team-by-woothemes/
 * @author 	WooThemes
 */
function woo_display_recent_projects() {
	get_template_part( 'includes/integrations/projects/template-recent-projects' );
}


/**
 * Display Recent Posts.
 *
 * Calls a template file to display the recent posts.
 *
 * @since  	2.0.0
 * @return 	void
 * @uses  	get_template_part()
 * @author 	WooThemes
 */
function woo_display_recent_posts() {
	get_template_part( 'includes/template-recent-posts' );
}

/**
 * Display Recent Posts Heading Text
 *
 * Returns the text to display, if any
 *
 * @since  	2.0.0
 * @return 	void
 * @uses  	get_option()
 * @author 	WooThemes
 */
function woo_recent_posts_heading( $heading ) {

	$show_recent_posts_heading = get_option( 'woo_home_post_heading', false );

	if ( $show_recent_posts_heading == "true" ) {

		$recent_posts_heading = get_option( 'woo_home_post_heading_text', __( 'Recent Posts','woothemes' ) );

		if ( '' != $recent_posts_heading ) {
			$heading = $recent_posts_heading;
		} else {
			$heading = __( 'Recent Posts','woothemes' );
		} // End If Statement

	} // End If Statement

	return $heading;
} // End woo_recent_posts_heading()

/**
 * Display Theme Slider.
 *
 * Calls a template file to display the slider.
 *
 * @since  	2.0.0
 * @return 	void
 * @uses  	get_template_part()
 * @author 	WooThemes
 */
function woo_slider() {
	if ( get_option('woo_featured') == "true" ) {
		get_template_part( 'slider' );
	} // End If Statement
}

/**
 * Display Footer Posts.
 *
 * Calls a template file to display posts in the footer.
 *
 * @since  	2.0.0
 * @return 	void
 * @uses  	get_template_part()
 * @author 	WooThemes
 */
function woo_footer_posts() {
	get_template_part( 'loop', 'footer' );
}