<?php
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Initilise the sidebar
 *
 * @since   1.0.0
 * @return 	void
 * @uses    register_sidebar()
 * @var 	int $footer_widget_regions the number of footer widget regions
 * @author 	WooThemes
 */
if ( ! function_exists( 'woo_widgets_init' ) ) {
	function woo_widgets_init() {

	    if ( ! function_exists( 'register_sidebar' ) ) return;

	    register_sidebar( array(
	    	'name' 				=> __( 'Primary', 'woothemes' ),
	    	'id' 				=> 'primary',
	    	'description' 		=> __( 'Default sidebar.', 'woothemes' ),
	    	'before_widget' 	=> '<section id="%1$s" class="widget %2$s">',
	    	'after_widget' 		=> '</section>',
	    	'before_title' 		=> '<h3><span>',
	    	'after_title' 		=> '</span></h3>'
	    	)
	    );

	    register_sidebar( array(
	    	'name' 				=> __( 'Header Area', 'woothemes' ),
	    	'id' 				=> 'header',
	    	'description' 		=> __( 'Header Area Widgets. Ideal for Ads.', 'woothemes' ),
	    	'before_widget' 	=> '<section id="%1$s" class="widget %2$s">',
	    	'after_widget' 		=> '</section>',
	    	'before_title' 		=> '<h3><span>',
	    	'after_title' 		=> '</span></h3>'
	    	)
	    );

		$footer_widget_regions = apply_filters( 'woo_footer_widget_regions', 4 );

		for ( $i = 1; $i <= intval( $footer_widget_regions ); $i++ ) {
			register_sidebar( array(
				'name' 				=> sprintf( __( 'Footer %d', 'woothemes' ), $i ),
				'id' 				=> sprintf( 'footer-%d', $i ),
				'description' 		=> sprintf( __( 'Widgetized Footer Region %d.', 'woothemes' ), $i ),
				'before_widget' 	=> '<div id="%1$s" class="widget %2$s">', 'after_widget' => '</div>',
				'before_title' 		=> '<h3>', 'after_title' => '</h3>'
				)
			);
		}
	}
}