<?php
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Theme JS
 *
 * Functions used to enqueue or otherwise directly related to javascript.
 *
 * @since   1.0.0
 * @author 	WooThemes
 */

/**
 * Add script.
 *
 * Enqueue various scripts
 *
 * @since  	1.0.0
 * @return 	void
 * @uses   	wp_enqueue_script()
 * @author 	WooThemes
 */
if ( ! function_exists( 'woothemes_add_javascript' ) ) {
	function woothemes_add_javascript() {
		global $woo_options;

		$suffix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

		// Register scripts
		wp_register_script( 'google-maps', 'http://maps.google.com/maps/api/js?sensor=false' );
		wp_register_script( 'google-maps-markers', get_template_directory_uri() . '/includes/js/markers.js' );

		// Enqueue third party scripts
		wp_enqueue_script( 'fitvids', get_template_directory_uri() . '/includes/js/fitvids' . $suffix . '.js', array( 'jquery' ), '1.0' );
		wp_enqueue_script( 'modernizr', get_template_directory_uri() . '/includes/js/modernizr' . $suffix . '.js', array( 'jquery' ), '2.6.2' );
		wp_enqueue_script( 'doubleTapToGo', get_template_directory_uri() . '/includes/js/jquery.doubleTapToGo' . $suffix . '.js', array( 'jquery' ), '1.0' );

		// Enqueue scripts
		wp_enqueue_script( 'general', get_template_directory_uri() . '/includes/js/general' . $suffix . '.js', array( 'jquery' ) );

		// Load Google Script on Contact Form Page Template
		if ( is_page_template( 'template-contact.php' ) ) {
			wp_enqueue_script( 'google-maps' );
			wp_enqueue_script( 'google-maps-markers' );
		} // End If Statement

		if ( get_option( 'woo_featured' ) == "true" && is_home() ) {
			wp_enqueue_script( 'spectrum-flexslider', get_template_directory_uri() . '/includes/js/jquery.flexslider' . $suffix . '.js', array( 'jquery' ), '2.2' );

			$autostart 			= get_option( 'woo_slider_auto', false );

		    if ( get_option( 'woo_slider_auto' ) == 'true' ) {
		    	$autostart = true;
		    } else {
		    	$autostart = false;
		    } // End If Statement

		    $slide_speed = 1;

		    if ( get_option( 'woo_slider_interval' ) <> '' ) {
		    	$slide_speed = get_option( 'woo_slider_interval', 1 ) * 1000;
		    } // End If Statement

		    $translation_array = array(
		    					'autostart' 		=> $autostart,
		    					'slidespeed' 		=> $slide_speed
		    					);

    		wp_localize_script( 'general', 'spectrumFlexslider', $translation_array );

		} // End If Statement

		do_action( 'woothemes_add_javascript' );
	} // End woothemes_add_javascript()
}