<?php
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Theme Actions
 *
 * This is where theme functions are hooked into the appropriate hooks / filters.
 *
 * @since   1.0.0
 * @author 	WooThemes
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 *
 * Used to set the width of images and content. Should be equal to the width the theme
 * is designed for, generally via the style.css stylesheet.
 */

if ( ! isset( $content_width ) ) {
	$content_width = 640;
}

/**
 * Actions
 */
add_action( 'after_setup_theme', 'woothemes_setup' );
add_action( 'wp_head', 'woo_load_responsive_meta_tags', 10 );
add_action( 'woo_head', 'woo_custom_styling', 10 );
add_action( 'woo_head','woo_custom_typography', 10 );
add_action( 'woo_header_before', 'woo_top_nav' );
add_action( 'woo_header_inside', 'woo_logo' );
add_action( 'homepage', 'woo_slider', 10 );
add_action( 'homepage', 'woo_display_recent_posts', 20 );
add_action( 'widgets_init', 'woo_widgets_init' );
add_action( 'woo_footer_before', 'woo_footer_posts', 10 );
add_filter( 'spectrum_recent_posts_heading', 'woo_recent_posts_heading', 10, 1 );

if ( ! is_admin() ) {
	add_action( 'wp_enqueue_scripts', 'woo_load_frontend_css', 20 );
	add_action( 'wp_enqueue_scripts', 'woothemes_add_javascript' );
}

/**
 * Filters
 */
add_filter( 'body_class','woo_layout_body_class', 10 );
add_filter( 'get_search_form', 'woo_customise_search_form' );