<?php
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Recent Posts Template
 * Displays the most recent posts
 *
 * @see woo_display_recent_posts()
 */
?>

<?php
global $woo_options;

$paged 		= ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;

$settings 	= array(
				'home_post_heading_text' 	=> __( 'Recent Posts', 'woothemes' ),
				'home_post_heading'			=> true,
			);
$settings 	= woo_get_dynamic_values( $settings );

$args 		= array(
				'posts_per_page' 	=> apply_filters( 'spectrum_recent_posts_limit', $limit = 10 ),
				'paged'				=> $paged,
			);

$exclude_posts = get_transient( 'woo_slider_query_exclusions' );
if ( empty( $exclude_posts ) ){
   // we have a transient return/assign the results
   $exclude_posts = array();
} // End If Statement

if ( is_array( $exclude_posts ) && ( get_option('woo_featured') == "true" ) ) {
	$args[ 'post__not_in' ] = $exclude_posts;
} // End If Statement

$the_query 	= new WP_Query( $args );

if ( $the_query->have_posts() ) { ?>

<div class="recent-posts">

	<?php if ( 'true' == $settings['home_post_heading'] ) {
		echo '<h1>' . $settings['home_post_heading_text'] . '</h1>';
	} ?>

	<?php while ( $the_query->have_posts() ) {

		$the_query->the_post();

		get_template_part( 'content', get_post_format() );

	} // End While Loop ?>

</div><!-- /.recent-posts -->

<?php } // End If Statement

wp_reset_postdata();