<?php
/**
 * Integrates this theme with the WooSlider plugin
 * http://www.woothemes.com/products/wooslider/
 */
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Support Declaration
 * @since   1.0.0
 * @return  void
 */
function wooslider_support() {
	add_theme_support( 'wooslider' );
}
add_action( 'after_setup_theme', 'wooslider_support' );


/**
 * Styles
 * @since   1.0.0
 * @return  void
 */
function woo_wooslider_scripts() {
	// dequeue the default wooslider styles
	wp_dequeue_style( 'wooslider-flexslider' );
	wp_dequeue_style( 'wooslider-common' );

	// Add our own
	wp_register_style( 'woo-wooslider-css', get_template_directory_uri() . '/includes/integrations/wooslider/css/wooslider.css' );
	wp_enqueue_style( 'woo-wooslider-css' );
}
add_action( 'wp_enqueue_scripts', 'woo_wooslider_scripts', 10 );