<?php
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * WooSlider Template
 * Displays an instance of wooslider()
 *
 * @see woo_display_wooslider()
 */
?>

<?php

if ( class_exists( 'WooSlider' ) ) {

	$slider_settings = apply_filters( 'woo_slider_template_settings', array(
		'slider_type'		=> 'slides',
		'smoothheight'		=> true,
		'direction_nav' 	=> true,
		'keyboard_nav' 		=> true,
		'mousewheel_nav' 	=> false,
		'playpause' 		=> 'play',
		'animation_loop' 	=> true,
		'pause_on_action' 	=> true,
		'pause_on_hover' 	=> true,
		'touch' 			=> true
		)
	);

	$slides_args = apply_filters( 'woo_slider_template_args', $args = array(
		'slide_page' 	=> 'homepage',
		'imageslide' 	=> 'true',
		'link_slide' 	=> 'true',
		'overlay' 		=> 'full',
		'layout' 		=> 'text-bottom',
		'display_title' => 'true'
		)
	);

	// Fire wooslider.
	wooslider( $slider_settings, $slides_args );

}