<?php
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Upsells
 * Replace the default upsell function with our own which displays the correct number product columns
 * @since   1.0.0
 * @return  void
 * @uses    woocommerce_upsell_display()
 */
if ( ! function_exists( 'woo_wc_upsell_display' ) ) {
	function woo_wc_upsell_display() {
	    woocommerce_upsell_display( -1, 3 );
	}
}

/**
 * Related Products
 * Replace the default related products function with our own which displays the correct number of product columns
 * @return array indicates number of products to display and in how many columns
 * @since  1.0.0
 */
function woo_wc_related_products() {
	$args = array(
		'posts_per_page' => 3,
		'columns'        => 3,
	);
	return $args;
}

/**
* Product Columns
* Set product columns to 3
* @return integer The number of columns products in archives are arranged into
* @since  1.0.0
*/
if ( ! function_exists( 'woo_wc_loop_columns' ) ) {
	function woo_wc_loop_columns() {
		return 3;
	}
}


/**
 * Before Content
 * Wraps all WooCommerce content in wrappers which match the theme markup
 * @since   1.0.0
 * @return  void
 * @uses  	woo_content_before(), woo_main_before()
 */
if ( ! function_exists( 'woo_wc_before_content' ) ) {
	function woo_wc_before_content() {
		?>
		<!-- #content Starts -->
		<?php woo_content_before(); ?>
	    <div id="content" class="col-full">

	        <!-- #main Starts -->
	        <?php woo_main_before(); ?>
	        <div id="main" class="col-left">

	    <?php
	} // End woo_wc_before_content()
}

/**
 * After Content
 * Closes the wrapping divs
 * @since   1.0.0
 * @return  void
 * @uses    woo_main_after(), do_action(), woo_content_after()
 */
if ( ! function_exists( 'woo_wc_after_content' ) ) {
	function woo_wc_after_content() {
		?>

			</div><!-- /#main -->
	        <?php woo_main_after(); ?>

	        <?php do_action( 'woocommerce_sidebar' ); ?>

	    </div><!-- /#content -->
		<?php woo_content_after(); ?>
	    <?php
	} // End woo_wc_after_content()
}

/**
 * Woo Body Class
 * Add a class to the body if full width shop archives are specified
 * @param  array $wc_classes Classes to be applied to the body
 * @return string            Classes to be applied to the body
 * @since  1.0.0
 */
if ( ! function_exists( 'woo_wc_layout_body_class' ) ) {
	function woo_wc_layout_body_class( $wc_classes ) {
		global $post;
		if ( is_singular( 'product' ) ) {
			$single_layout = get_post_meta( $post->ID, '_layout', true );
		}

		$layout = '';

		// Add layout-full class to product archives if necessary
		if ( has_filter( 'woo_wc_shop_sidebar', false ) && ( is_shop() || is_product_category() ) ) {
			$layout = 'layout-full';
		}
		// Add layout-full class to single product pages if necessary
		if ( ( has_filter( 'woo_wc_product_sidebar', false ) && is_product() ) && ( $single_layout != 'layout-left-content' && $single_layout != 'layout-right-content' ) ) {
			$layout = 'layout-full';
		}

		// Add classes to body_class() output
		$wc_classes[] = $layout;
		return $wc_classes;
	} // End woocommerce_layout_body_class()
}

/**
 * Woo Get Sidebar
 * Replaces the WooCommerce sidebar with one which checks whether the full-width theme option is enabled.
 * @since   1.0.0
 * @uses    is_product(), get_sidebar(), is_singular(), get_post_meta()
 * @return  void
 */
if ( ! function_exists( 'woo_wc_get_sidebar' ) ) {
	function woo_wc_get_sidebar() {
		global $post;

		if ( ! is_product() ) {
			if ( apply_filters( 'woo_wc_shop_sidebar', true ) ) {
				get_sidebar( 'shop' );
			}
		} else {
			if ( is_singular( 'product' ) ) {
				$single_layout = get_post_meta( $post->ID, '_layout', true );
			}
			if ( apply_filters( 'woo_wc_product_sidebar', true ) && $single_layout != "layout-full" ) {
				get_sidebar( 'shop' );
			}
		}

	} // End woo_wc_get_sidebar()
}

/**
 * WooCommerce Pagination
 * Replaces WooCommerce pagination with the function in the WooFramework
 * @uses  woo_wc_add_search_fragment()
 * @uses  woo_wc_pagination_defaults()
 * @uses  woo_pagination()
 * @since  1.0.0
 * @return  void
 */
if ( ! function_exists( 'woo_wc_pagination' ) ) {
	function woo_wc_pagination() {
		if ( is_search() && is_post_type_archive() ) {
			add_filter( 'woo_pagination_args', 			'woo_wc_add_search_fragment', 10 );
			add_filter( 'woo_pagination_args_defaults', 'woo_wc_pagination_defaults', 10 );
		}
		woo_pagination();
	} // End woo_wc_pagination()
}

/**
 * Search Fragment
 * @param  array $settings Fragments
 * @return array           Fragments
 * @since  1.0.0
 */
if ( ! function_exists( 'woo_wc_add_search_fragment' ) ) {
	function woo_wc_add_search_fragment ( $settings ) {
		$settings['add_fragment'] = '&post_type=product';
		return $settings;
	} // End woo_wc_add_search_fragment()
}

/**
 * Pagination Defaults
 * @param  array $settings Settings
 * @return array           Settings
 * @since  1.0.0
 */
if ( ! function_exists( 'woo_wc_pagination_defaults' ) ) {
	function woo_wc_pagination_defaults ( $settings ) {
		$settings['use_search_permastruct'] = false;
		return $settings;
	} // End woo_wc_pagination_defaults()
}

/**
 * Cart Link
 * Displayed a link to the cart including the number of items present and the cart total
 * @param  array $settings Settings
 * @return array           Settings
 * @since  1.0.0
 */
if ( ! function_exists( 'woo_wc_cart_link' ) ) {
	function woo_wc_cart_link() {
		global $woocommerce;
		?>
		<a class="cart-contents" href="<?php echo $woocommerce->cart->get_cart_url(); ?>" title="<?php _e( 'View your shopping cart', 'woothemes' ); ?>">
			<?php echo $woocommerce->cart->get_cart_total(); ?> <span class="count"><?php echo sprintf( _n( '%d item', '%d items', $woocommerce->cart->get_cart_contents_count(), 'woothemes' ), $woocommerce->cart->get_cart_contents_count() );?></span>
		</a>
		<?php
	}
}

/**
 * Change number of products per page
 *
 * @return interger number of products
 * @since  1.0.0
 */
function woo_wc_loop_per_page( $per_page ) {
	$per_page = 12;
	return $per_page;
}