<?php
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Recent Products Template
 * Displays recent products using the WooCommerce recent_products shortcode.
 *
 * @see woo_display_recent_products()
 */
?>

<?php if ( is_woocommerce_activated() ) { ?>
	<section class="recent-products">
		<h1 class="section-title"><?php _e( 'Recent Products', 'woothemes' ); ?></h1>
		<?php
			$recent_products_limit 		= apply_filters( 'woo_template_recent_products_limit', $limit = 6 );
			$recent_products_columns 	= apply_filters( 'woo_template_recent_products_columns', $columns = 3 );
			echo do_shortcode( '[recent_products per_page="' . $recent_products_limit . '" columns="' . $recent_products_columns . '"]' );
		?>
	</section>
<?php }