<?php
if ( ! defined( 'ABSPATH' ) ) exit;
/**
 * Footer Template
 *
 * Here we setup all logic and HTML that is required for the footer section of all screens.
 *
 * @package WooFramework
 * @subpackage Template
 */

global $woo_options;

	if ( is_active_sidebar( 'footer-4' ) ) {
		$widget_columns = apply_filters( 'woo_footer_widget_regions', 4 );
	} elseif ( is_active_sidebar( 'footer-3' ) ) {
		$widget_columns = apply_filters( 'woo_footer_widget_regions', 3 );
	} elseif ( is_active_sidebar( 'footer-2' ) ) {
		$widget_columns = apply_filters( 'woo_footer_widget_regions', 2 );
	} elseif ( is_active_sidebar( 'footer-1' ) ) {
		$widget_columns = apply_filters( 'woo_footer_widget_regions', 1 );
	} else {
		$widget_columns = apply_filters( 'woo_footer_widget_regions', 0 );
	}

?>

		<?php woo_footer_before(); ?>

		<div class="footer-wrap">

			<?php

			/**
			 * Footer Widgets
			 */

			if ( $widget_columns > 0 ) { ?>

				<section id="footer-widgets" class="col-full col-<?php echo $widget_columns; ?> fix">

					<?php $i = 0; while ( $i < $widget_columns ) : $i++; ?>

						<?php if ( woo_active_sidebar( 'footer-' . $i ) ) : ?>

							<section class="block footer-widget-<?php echo $i; ?>">
					        	<?php woo_sidebar( 'footer-' . $i ); ?>
							</section>

				        <?php endif; ?>

					<?php endwhile; ?>

				</section><!-- /#footer-widgets  -->

			<?php } // End If Statement

			/**
			 * Copyright & Credit
			 */

			if ( get_option( 'woo_footer_credit', 'true' ) == 'true' ) {
			?>
			<div class="copy-wrap">

				<footer id="footer" class="col-full">

					<?php if ( apply_filters( 'woo_footer_copyright', true ) ) : ?>

					<div id="copyright" class="col-left">
						<p>
							 &copy; <?php echo date( 'Y' ); ?>. <?php _e( 'Copyright 2015 Droemmekaeresten.dk. Kopiering af artikler og andet indhold spores!', 'woothemes' ); ?>
						</p>
					</div>

					<?php endif; ?>

					<?php if ( apply_filters( 'woo_footer_credit', true ) ) : ?>

					<div id="credit" class="col-right">
						
					</div
<p></p>
					<?php endif; ?>

					<?php
					if ( $woo_options['woo_logo'] ) {
						woo_logo();
					}
					?>

				</footer><!-- /#footer  -->

			</div><!--/.copy-wrap -->
			<?php } // End If Statement ?>
		</div><!-- /.footer-wrap -->

	</div><!-- /#inner-wrapper -->

</div><!-- /#wrapper -->

<?php wp_footer(); ?>

<?php woo_foot(); ?>

</body>

</html>