<?php
if (empty($meta))
	return;

$categoryId = $meta['category_id'] ?? 'none';
if ('none' === $categoryId)
	return;

$category = get_category($categoryId);
if (0 === $category->category_count)
	return;

ob_start();
$image_position = @$meta['image_position'];
$image_id = get_term_meta($categoryId, 'thumbnail_id', true);
$over_title = $category->name;
$over_title_link = get_term_link($category);
?>
<article class="clear image_and_description <?= $image_position; ?>" id="section-<?php echo $post_section_id; ?>" <?php echo $style; ?>>
	<div>
		<div class="section_content <?php echo $image_position; ?>">
			<div>
				<?php
					if ('' !== $over_title) {
						if ('' !== $over_title_link) {
							echo '<div class="over_title"><a href="'.$over_title_link.'">'.$over_title.'</a></div>';
						} else {
							echo '<div class="over_title">'.$over_title.'</div>';
						}
					}
				?>
				<?php if (!empty($meta['title'])) { ?>
					<h2><?php echo $meta['title']; ?></h2>
				<?php } ?>
				<?php echo wTheme::get_the_content($category->description); ?>
				<p><a class="general_button" href="<?= $over_title_link; ?>"><?= wTheme::__('Se alle artikler'); ?></a></p>
			</div>
			<?php
			if (!empty($image_id)) {
				echo wp_get_attachment_image($image_id, wTheme::prefix('image_and_description_thumb'));
			}
			?>
		</div>
	</div>
</article>
<?php $box_content = ob_get_clean(); ?>
<?php if ('' !== $box_content) { ?>
	<?php echo $box_content; ?>
	<script>
		jQuery(function() {
			var $section = jQuery('#section-<?= $post_section_id; ?>'),
				window_height = jQuery(window).height(),
				window_offset = jQuery(window).scrollTop(),
				section_offset = $section.offset().top - window_height/1.2,
				flag = 0;

			jQuery(window).scroll(function() {
				window_offset = jQuery(window).scrollTop();

				if ((window_offset > section_offset) && 0 === flag) {
					$section.find('.section_content >*').animate({left:0,opacity:1}, 600);
					flag = 1;
				}
			}).trigger('scroll');
		});
	</script>
<?php } ?>

