<?php
	$schema_author_is_active = get_post_meta(get_the_ID(), wTheme::prefix('schema_author_is_active'), true);
	$schema_author_user_id = get_post_meta(get_the_ID(), wTheme::prefix('schema_author_user_id'), true);
	$organization_name = 'Doc24.dk';
	$user_id = isset($schema_author_user_id) ? $schema_author_user_id : get_the_author_meta('ID');
?>
<?php if ('1' === $schema_author_is_active) { ?>
<div itemscope itemtype="http://schema.org/NewsArticle" style="display: none;">
	<a itemprop="mainEntityOfPage" href="<?php the_permalink(); ?>"></a>
	<span itemprop="headline"><?php the_title(); ?></span>
	<span itemprop="datePublished"><?php echo get_the_date('Y-m-d H:i'); ?></span>
	<span itemprop="dateModified"><?php echo get_the_modified_date('Y-m-d H:i'); ?></span>
	<span itemprop="image" itemscope itemtype="https://schema.org/ImageObject">
		<?php
			if (has_post_thumbnail()) {
				?>
				<meta itemprop="url" content="<?= get_the_post_thumbnail_url(get_the_ID()); ?>">
				<?php
			} else {
				$avatar_user_id = isset($user_id) ? $user_id : get_the_author_meta('ID');
				?>
				<meta itemprop="url" content="<?= get_avatar_url($avatar_user_id); ?>">
				<?php
			}
		?>
	</span>
	<div itemprop="publisher" itemscope itemtype="https://schema.org/Organization">
		<a href="<?php echo esc_url(home_url('/')); ?>" itemprop="url"></a>
		<span itemprop="name"><?php echo $organization_name; ?></span>
		<?php
			//todo check not svg image
			//			$logo_options = wThemeSettings::get_option('Header.site_logo');
			//			$image_url = wp_get_attachment_image_url(@$logo_options['attachment_id'], 'full');
			//			if (empty($image_url))
			$image_url = get_template_directory_uri().'/images/logo.png';
		?>
		<div itemprop="logo" itemscope itemtype="http://schema.org/ImageObject">
			<meta itemprop="url" content="<?php echo $image_url; ?>" />
		</div>
	</div>
	<span itemprop="author" itemscope itemtype="http://schema.org/Person">
		<?php $author_url = get_author_posts_url(@$user_id); ?>
		<?php if ($author_url) { ?>
			<a itemprop="url" href="<?php echo $author_url ?>"><?php echo $author_url ?></a>
		<?php } ?>
		<span itemprop="name"><?php echo get_the_author_meta('display_name', @$user_id); ?></span>
	</span>
</div>
<?php } ?>