<?php

$args = array(
	'post_type' => wPostSection::$post_type,
	'post_status' => 'publish',
	'post_parent' => get_the_ID(),
	'orderby' => 'menu_order ID',
	'order' => 'ASC',
	'suppress_filters' => true,
	'posts_per_page' => -1,
);

$section_query = new WP_Query($args);
if(!$section_query->have_posts())
	return;

?>
<div class="post_sections">
	<?php
	while ($section_query->have_posts()) { $section_query->the_post();
		$post_section_id = get_the_ID();
		$meta = wPostSection::get_all_meta($post_section_id);
		$layout = $meta['layout'];

		//settings from bg_color_settings()
		$bg_color = @$meta['background_color'];
		$is_parallax = @$meta['is_parallax'];
		$text_color = @$meta['text_color'];
		$bg_image = @$meta['bg_thumbnail_id'];
		$padding_top = @$meta['padding_top'];
		$padding_bottom = @$meta['padding_bottom'];
		$offset_top = @$meta['offset_top'];
		$offset_bottom = @$meta['offset_bottom'];

		$style = '';
		$fixed_bg = (!empty($is_parallax) && '1' == $is_parallax) ? ' fixed' : '';
		$bg = !empty($bg_image) ? ' url('.wp_get_attachment_url($bg_image).') no-repeat 50% 50% / cover'.$fixed_bg : '';

		if (!empty($bg_color) || !empty($bg))
			$style = 'background:'.$bg_color.$bg.';';

		if (!empty($text_color))
			$style .= 'color:'.$text_color.';';

		if (!empty($offset_top))
			$style .= "margin-top:{$offset_top}px;";

		if (!empty($offset_bottom))
			$style .= "margin-bottom:{$offset_bottom}px;";

		if (!empty($padding_top))
			$style .= "padding-top:{$padding_top}px;";

		if (!empty($padding_bottom))
			$style .= "padding-bottom:{$padding_bottom}px;";

		if (!empty($style))
			$style = 'style="'.$style.'"';

		?>
		<article class="clear <?php echo $layout; ?>" id="section-<?php echo $post_section_id; ?>" <?php echo $style; ?>>
			<?php if ('default' == $layout) { ?>
				<?php echo wTheme::part('section/default', compact('meta')); ?>
			<?php } else if ('category_box' == $layout) { ?>
				<?php echo wTheme::part('section/category_box', compact('meta')); ?>
			<?php } else if ('news' == $layout) { ?>
				<?php echo wTheme::part('latest_posts'); ?>
			<?php } else if ('newsletter' == $layout) { ?>
				<?php echo wTheme::part('newsletter'); ?>
			<?php } else if ('image_and_description' == $layout) { ?>
				<?php echo wTheme::part('section/image_and_description', compact('meta')); ?>
			<?php } else if ('testimonial_box' == $layout) { ?>
				<?php $section_title = get_the_title(); ?>
				<?php echo wTheme::part('section/testimonial_box', compact('meta', 'style', 'post_section_id', 'section_title')); ?>
			<?php } else if ('counters_box' == $layout) { ?>
				<?php echo wTheme::part('section/counters_box', compact('meta')); ?>
			<?php } ?>
		</article>
	<?php } ?>
	<?php wp_reset_postdata(); ?>
</div>