<?php
$time = '<time datetime="'.get_the_date('Y-m-d H:i').'">'.get_the_date('d. F Y').'</time>';
if (is_single()) {
	setPostViews(get_the_ID());
	$meta = wPost::get_all_meta(get_the_ID(), true);
	$short_description = @$meta['short_description'];
	?>
	<article>
		<header class="entry_header">
			<h1 class="entry_title"><?php the_title(); ?></h1>
			<?php if (!empty($short_description)) { ?>
				<div class="short_description_wrap"><?php echo wTheme::get_the_content($short_description, false); ?></div>
			<?php } ?>
		</header>
		<?php if (has_post_thumbnail()) { ?>
			<div class="post_thumb">
				<?php the_post_thumbnail(wTheme::prefix('post_thumb')); ?>
			</div>
		<?php } ?>
		<div class="time">
			<span><?php echo wTheme::__('Published').' '.get_the_date('d.m.Y'); ?></span>
			<span class="divider">|</span>
			<span class="modified_date"><?php echo wTheme::__('Last edited').' '.get_the_modified_date('d.m.Y'); ?></span>
			<span class="divider">|</span>
			<span class="advertising"><?= wTheme::__('Artiklen indeholder ads'); ?></span>
		</div>
		<?php if (wp_is_mobile()) { ?>
			<div class="reviewed_by">
				<?php echo wTheme::part('reviewed_by') ?>
			</div>
		<?php } ?>
		<?php echo wTheme::part('entry-content'); ?>
		<script>
			wLoad(function() {
				var $items = jQuery('.single-post .pros_list, .single-post .cons_list');
				var max_height = 0;
				var current_height = 0;
				$items.each(function(){
					current_height = jQuery(this).outerHeight();
					if (current_height >= max_height) {
						max_height = current_height;
					}
				});
				$items.outerHeight(max_height);
			});
		</script>
	</article>
<?php } else { ?>
	<article class="post">
		<?php if (is_category()) { ?>
			<header class="entry_header">
				<h2><a href="<?php the_permalink(); ?>"><?php echo wTheme::truncate(get_the_title(), 50); ?></a></h2>
				<?php $permalink = get_permalink(); ?>
			</header>
			<a class="post_thumb_list" href="<?php the_permalink(); ?>">
				<?php if (has_post_thumbnail()) { ?>
					<?php the_post_thumbnail(wTheme::prefix('post_thumb_list2')); ?>
				<?php } ?>
			</a>
			<div class="entry_content">
				<?php echo wTheme::truncate(wTheme::get_the_content(), 150, '&#8230;'); ?>
				<p class="read_more_wrap"><a class="read_more hide_arrow" href="<?php echo $permalink; ?>"><?php wTheme::_e('Read more'); ?></a></p>
			</div>
		<?php } else { ?>
			<a class="post_thumb_list" href="<?php the_permalink(); ?>">
				<?php if (has_post_thumbnail()) { ?>
					<?php the_post_thumbnail(wTheme::prefix('post_thumb_list')); ?>
				<?php } ?>
			</a>
			<div class="wrap">
				<header class="entry_header">
					<h2><a href="<?php the_permalink(); ?>"><?php echo wTheme::truncate(get_the_title(), 50); ?></a></h2>
					<!--					--><?php //echo $time; ?>
				</header>
				<div class="entry_content">
					<?php $more = '&#8230;'; ?>
					<?php echo wTheme::truncate(wTheme::get_the_excerpt(), 90, $more); ?>
					<!--					<a class="read_more" href="--><?php //echo get_permalink(); ?><!--"></a>-->
				</div>
			</div>
		<?php } ?>
	</article>
<?php } ?>
