function wtheme_adwords_calc_pp(total, subtotal) {
	return Math.abs(Math.round((subtotal / total * 10000) / 100));
}

function wtheme_adwords_to_thousands(n) {
	return n.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
}

function wtheme_adwords_calc_init(selector) {
	var $calc = jQuery(selector);
	var $price_input = $calc.find('.price input');
	var $results = jQuery('.results');
	var $results_table = jQuery('.results table');
	var $price = jQuery('.results .summary .price');
	var $total = jQuery('.results .total .price, .results .summary .total');
	var $total_persentage = jQuery('.results .total .persentage, .results .summary .total_persentage');

	$calc.find('input:text').bind('input propertychange', function(e) {
		var value = 0;
		this.value = this.value.replace(/\D/g, '');
		if ('' !== this.value)
			value = parseInt(this.value);
		jQuery(this).data('value', value);
		this.value = wtheme_adwords_to_thousands(this.value);
	});

	$calc.find('form').submit(function () {
		var price = $price_input.data('value');
		var total = 0, total_persentage = 0;

		if (!(price > 0)) {
			$price_input.focus();
			return false;
		}

		$results_table.find('tr.row').hide();
		var $checkboxes = $calc.find('input:checkbox:checked');
		var $inputs = $calc.find('input:radio:checked');
		if (1 == $checkboxes.length()) {
			var $first = $checkboxes.first();
			if ('broad' == $first.val())
				$inputs = jQuery.merge($first, $inputs);
		}

		$inputs.each(function () {
			var rate = jQuery(this).data('rate') || 0;
			if (0 == rate)
				return;

			var name = jQuery(this).attr('name').replace('[]', '');
			var sub_price = Math.abs(Math.round(price * rate));
			var persentage = wtheme_adwords_calc_pp(price, sub_price);
			total += sub_price;
			total_persentage += persentage;
			var $row = $results_table.find('.'+name);
			$row.find('.sub_price').text(wtheme_adwords_to_thousands(sub_price));
			$row.find('.persentage').text(persentage);
			$row.show();
		});

		$price.text(wtheme_adwords_to_thousands(price));
		$total.text(wtheme_adwords_to_thousands(total));
		$total_persentage.text(total_persentage);

		$results.show();

		jQuery('html, body').animate({
			scrollTop: $results.offset().top - 30
		}, 300);

		if (typeof dataLayer === 'object')
			dataLayer.push({'event': 'gtm.adwords-calc'});
		return false;
	});
}
