<?php

require_once get_template_directory().'/inc/wLib/wSection.php';

class wPostSection extends wSection {

	static $post_type;
	static $all_post_types = array();

	static $category_box_action = 'wtheme_category_box_request';
	static $page_template = 'page-templates/page_sections.php';
	static $post_box_action = 'wtheme_post_box_request';

	function get_post_types() {
		return array('post');
	}

	function add_hooks() {
		parent::add_hooks();
		add_action('admin_action_'.self::$post_box_action, array($this, 'admin_action_'.self::$post_box_action));
		add_action('admin_action_'.self::$category_box_action, array($this, 'admin_action_'.self::$category_box_action));
		add_action('wp_loaded', array($this, 'action__all_post_type'));
	}

	var $layouts = array(
		'default' => array('label'=>'Default'),
		'image_and_description' => array('label' => 'Category 50/50'),
		'category_box' => array('label' => 'Category box'),
		'testimonial_box' => array('label' => 'Testimonial box'),
		'news' => array('label' => 'News box'),
		'newsletter' => array('label' => 'Newsletter box'),
		'counters_box' => array('label' => 'Counters box'),
	);

	function action__all_post_type(){
		$post_types = array(
			'post',
			wProduct::$post_type,
		);

		foreach ($post_types as $post_type) {
			$post_type_object = get_post_type_object($post_type);
			if ($post_type_object) {
				self::$all_post_types[$post_type] = $post_type_object->labels->singular_name;
			}
		}
	}

	function section_image_and_description($section_post, $meta_key) {
		$data = self::get_all_meta($section_post->ID);
		if (!isset($data['image_position']))
			$data['image_position'] = 'left';
		?>
		<div>
			<p class="image_and_description_section_image_position-<?php echo $section_post->ID; ?>">
				<span><?php wTheme::_e('Select image position'); ?></span><br />
				<?php $field = 'image_position'; $field_name = $section_post->ID.'.'.$field; ?>
				<label for="image_position-left-<?php echo $section_post->ID; ?>">
					<input type="radio" name="<?php $this->field_name($field_name, $meta_key); ?>" value="left" id="image_position-left-<?php echo $section_post->ID; ?>" <?php checked(@$data[$field], 'left'); ?> />
					<?php echo wTheme::__('Left'); ?>
				</label>
				<label style="margin-left:10px;" for="image_position-right-<?php echo $section_post->ID; ?>">
					<input type="radio" name="<?php $this->field_name($field_name, $meta_key); ?>" value="right" id="image_position-right-<?php echo $section_post->ID; ?>" <?php checked(@$data[$field], 'right'); ?> />
					<?php echo wTheme::__('Right'); ?>
				</label>
			</p>
			<p>
				<?php
					$field = "category_id"; $field_name = $section_post->ID.'.'.$field;
					$categories = get_categories();
				?>
				<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Select post type'); ?></label><br />
				<select name="<?php $this->field_name($field_name, $meta_key); ?>" id="<?php $this->field_id($field_name, $meta_key); ?>">
					<option value="none"><?php wTheme::_e('None'); ?></option>
					<?php foreach ($categories as $category) { ?>
						<option value="<?php echo $category->term_id; ?>" <?php selected(@$data[$field], $category->term_id); ?>><?= $category->name; ?></option>
					<?php } ?>
				</select>
			</p>
		</div>
		<?php
	}

	function section_category_box($section_post, $meta_key) {
		$data = self::get_all_meta($section_post->ID);

		if (!isset($data['type']))
			$data['type'] = 'latest';
		?>
		<p>
			<label><?php wTheme::_e('Title'); ?></label><br />
			<input type="text" name="<?php $this->field_name($section_post->ID.'.post_title', $meta_key); ?>" value="<?php echo esc_attr($section_post->post_title); ?>" class="large-text" />
		</p>
		<div class="category_ajax-<?php echo $section_post->ID; ?>">
			<p class="post_type_select">
				<?php $field = "post_type"; $field_name = $section_post->ID.'.'.$field; ?>
				<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Select post type'); ?></label><br />
				<select name="<?php $this->field_name($field_name, $meta_key); ?>" id="<?php $this->field_id($field_name, $meta_key); ?>">
					<option value="none"><?php wTheme::_e('None'); ?></option>
					<?php foreach (self::$all_post_types as $post_t=>$label) { ?>
						<option value="<?php echo $post_t; ?>" <?php selected(@$data[$field], $post_t); ?>><?php echo wTheme::__($label); ?></option>
					<?php } ?>
				</select>
			</p>
			<div class="category_box_wrap"></div>
		</div>
		<script>
			jQuery(function () {
				var $ajax_box = jQuery('.category_ajax-<?php echo $section_post->ID; ?>');
				var $post_type_select = jQuery('.post_type_select select', $ajax_box);
				$post_type_select.change(function () {
					var $this = jQuery(this);
					var $category_box_wrap = jQuery('.category_box_wrap', $ajax_box);
					var val = $this.val();
					if ('none' === val) {
						$category_box_wrap.empty();
						return false;
					}

					jQuery.post(
						'<?php echo admin_url('admin.php?action='.self::$category_box_action); ?>',
						$ajax_box.find(':input').serialize()
						,function (response) {
							var response = jQuery.parseJSON(response);
							$category_box_wrap.empty();
							$category_box_wrap.append(response.category_box);
						});
					return false;
				}).change();
			});
		</script>
		<?php
	}

	function admin_action_wtheme_category_box_request() {
		if (!current_user_can('edit_posts'))
			die;


		$meta_key = wTheme::prefix('save_sections');
		foreach ($_POST['data'][$meta_key] as $key=>$value) {
			$id = $key;
			$data = $value;
		}

		$response = array();
		$meta = self::get_all_meta($id);

		if (empty($data))
			die;

		if (empty($data['post_type']))
			$data['post_type'] = @$meta['post_type'];

		$post_type = $data['post_type'];
		$taxonomy = get_object_taxonomies($post_type)[0];

		if ('none' == $post_type)
			die;

		ob_start();
		?>
		<!-- Category list select -->
		<div class="category_list">
			<p><?php echo wTheme::__('Select categories').':'; ?></p>
			<?php for ($i = 0; $i < 4; $i++) { ?>
				<div style="width:24.5%;display:inline-block;vertical-align:top;">
					<?php $field = "category_{$i}"; $field_name = $id.'.'.$field; ?>
					<?php
					if (empty($data[$field]))
						$data[$field] = @$meta[$field];

					if ($post_type !== @$meta['post_type'])
						$data["category_{$i}"] = 'none';

					echo wp_dropdown_categories(
						array(
							'taxonomy'=>$taxonomy,
							'echo'	=> 0,
							'name'	=>	$this->field_name($field_name, $meta_key, true),
							'id'	=>	$this->field_id($field_name, $meta_key, true),
							'value_field'	=>	'term_id',
							'show_option_none'  => 'None',
							'option_none_value' => 'none',
							'selected'	=>	!empty($data[$field]) ? $data[$field] : @$meta[$field]
						)
					);
					?>
				</div>
			<?php } ?>
		</div>
		<?php
		$post_box = ob_get_clean();

		$response['category_box'] = $post_box;

		echo json_encode($response);
		die;
	}

	function section_testimonial_box($section_post, $meta_key) {
		$this->title_field($section_post, $meta_key);
		wTheme::_e('Show testimonial carousel');
		//$data = self::get_all_meta($section_post->ID);
	}

	function section_news($section_post, $meta_key) {
		$this->title_field($section_post, $meta_key);
		wTheme::_e('Show News');
	}

	function section_newsletter($section_post, $meta_key) {
		$this->title_field($section_post, $meta_key);
		wTheme::_e('Newsletter');
	}

	function section_counters_box($section_post, $meta_key) {
		$this->title_field($section_post, $meta_key);
		$data = self::get_all_meta($section_post->ID);
		$counterTypes = ['Value', 'Price', 'Year', 'Percentage'];
		?>
		<p>
			<?php echo wTheme::get_media_popup_field($this->field_name($section_post->ID.'.image_id', $meta_key, true), @$data['image_id'], wTheme::__('Select top image')); ?>
		</p>
		<?= wTheme::__('Counters'); ?>
		<div>
			<?php for ($i=0; $i<4; $i++) { ?>
				<?php $k = $i + 1; ?>
				<div class="counter_wrap" style="vertical-align: top; width: 23%; padding-right: 10px; display: inline-block;">
					<h3><?= wTheme::__('Counter ')." {$k}"; ?></h3>
					<p class="counter_type">
						<?php
							$field = 'type_'.$i;
							$field_name = $section_post->ID . '.' . $field;
						?>
						<label for="<?php $this->field_id($field_name, $meta_key); ?>"><?php echo wTheme::__('Counter type'); ?></label><br/>
						<select name="<?php $this->field_name($field_name, $meta_key); ?>" id="<?php $this->field_id($field_name, $meta_key); ?>">
							<?php foreach ($counterTypes as $key=>$type) { ?>
								<option value="<?= $key; ?>" <?php selected(@$data[$field], $key); ?>><?= $type; ?></option>
							<?php } ?>
						</select>
					</p>
					<p>
						<?php
							$field = 'counter_'.$i;
							$field_name = $section_post->ID . '.' . $field;
						?>
						<label for="<?php $this->field_id($field_name, $meta_key); ?>"><?php echo wTheme::__('Counter'); ?></label><br/>
						<input type="number" name="<?php $this->field_name($field_name, $meta_key); ?>"
						       value="<?php echo esc_attr(@$data[$field]); ?>"
						       id="<?php $this->field_id($field_name, $meta_key); ?>" class="large-text"/>

					</p>
					<p>
						<?php $field = 'counter_label_'.$i; $field_name = $section_post->ID.'.'.$field; ?>
						<label for="<?php $this->field_id($field_name, $meta_key); ?>"><?php echo wTheme::__('Label'); ?></label><br />
						<input type="text" name="<?php $this->field_name($field_name, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field_name, $meta_key); ?>" class="large-text" />
					</p>
					<div class="type_3" style="display:none;">
						<p>
							<?php
								$field = 'counter2_'.$i;
								$field_name = $section_post->ID . '.' . $field;
							?>
							<label for="<?php $this->field_id($field_name, $meta_key); ?>"><?php echo wTheme::__('Counter 2'); ?></label><br/>
							<input type="number" name="<?php $this->field_name($field_name, $meta_key); ?>"
								   value="<?php echo esc_attr(@$data[$field]); ?>"
								   id="<?php $this->field_id($field_name, $meta_key); ?>" class="large-text"/>

						</p>
						<p>
							<?php $field = 'counter_label2_'.$i; $field_name = $section_post->ID.'.'.$field; ?>
							<label for="<?php $this->field_id($field_name, $meta_key); ?>"><?php echo wTheme::__('Label 2'); ?></label><br />
							<input type="text" name="<?php $this->field_name($field_name, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field_name, $meta_key); ?>" class="large-text" />
						</p>
					</div>
				</div>
			<?php } ?>
			<script>
				jQuery(function () {
					var $scope = jQuery('.counter_wrap');
					var $typeSelect = $scope.find('.counter_type select');
					$typeSelect.on('change', function () {
						if ('3' === jQuery(this).val()) {
							jQuery(this).closest('.counter_wrap').find('.type_3').show();
						} else {
							jQuery(this).closest('.counter_wrap').find('.type_3').hide();
						}
					}).trigger('change');
				});
			</script>
		</div>
		<?php
	}

}

