<?php

class wPost extends wCustomPostType {

	static $post_type;

	function action__add_meta_boxes($post) {
		parent::action__add_meta_boxes($post);
		add_meta_box(wTheme::prefix('additional_fields'), wTheme::__('Additional fields'), array($this, 'meta_box_additional_fields'), $this->post_type(), 'advanced', 'low');
		add_meta_box(wTheme::prefix('more_information'), wTheme::__('Find more information here'), array($this, 'meta_box_more_information'), $this->post_type(), 'advanced', 'low');
		//add_meta_box(wTheme::prefix('rating'), wTheme::__('Rating'), array($this, 'meta_box_rating'), $this->post_type(), 'side', 'low');
		add_meta_box(wTheme::prefix('recommended_product'), wTheme::__('Recommended product'), array($this, 'meta_box_recommended_product'), $this->post_type(), 'side', 'low');
		add_meta_box(wTheme::prefix('short_description'), wTheme::__('Short description'), array($this, 'meta_box__short_description'), $this->post_type(), 'advanced', 'low');
		//add_meta_box(wTheme::prefix('featured_bg_color'), wTheme::__('Featured background color'), array($this, 'meta_box__featured_bg_color'), $this->post_type(), 'side', 'low');
		add_meta_box(wTheme::prefix('product_schema_settings'), wTheme::__('Product schema'), array($this, 'meta_box_product_schema_settings'), $this->post_type(), 'advanced', 'low');
	}

	function meta_box_more_information($post) {
		$meta_key = wTheme::prefix('more_information');
		$data = self::get_all_meta($post->ID);
		$this->nonce_field($meta_key);
		wp_editor(@$data['more_information'], 'more_information', array('textarea_name'=>$this->field_name('more_information', $meta_key, true)));
	}

	function meta_box_recommended_product($post) {
		$meta_key = wTheme::prefix('recommended_product');
		$this->nonce_field($meta_key);
		$data = self::get_all_meta($post->ID);
		?>
		<p>
			<label for="<?php $this->field_id('recommended_product', $meta_key); ?>"><?php wTheme::_e('Product ID'); ?></label><br />
			<input type="text" name="<?php $this->field_name('recommended_product', $meta_key); ?>" value="<?php echo esc_attr(@$data['recommended_product']); ?>" id="<?php $this->field_id('recommended_product', $meta_key); ?>" />
		</p>
		<?php
	}

	function action__save_post($post_id) {
		$this->save_meta_data($post_id, wTheme::prefix('more_information'));
		$this->save_meta_data($post_id, wTheme::prefix('recommended_product'));
		$this->_save_rating($post_id);
		$this->save_meta_data($post_id, wTheme::prefix('product_schema_settings'), false, true);
		//var_dump($_POST['data']['wtheme_product_schema_settings']['review']);die;
		$this->save_meta_data($post_id, wTheme::prefix('additional_fields'));
		$this->save_meta_data($post_id, wTheme::prefix('short_description'));

		$meta_key = wTheme::prefix('featured_bg');
		if ($this->can_save_meta_data($post_id, $meta_key)) {
			$color = @$_POST['data'][$meta_key]['color'];
			$color_rgb = '';
			if ('' !== $color) {
				/*if (strlen($color) < 7) {
					$color =
				}*/
				list($r, $g, $b) = sscanf($color, "#%02x%02x%02x");
				 $color_rgb = "{$r}, {$g}, {$b}";
			}
			$_POST['data'][$meta_key]['color_rgb'] = $color_rgb;
			$this->save_meta_data($post_id, wTheme::prefix('featured_bg'), false, true);
		}
	}

	private function _save_rating($post_id) {
		$this->save_meta_data($post_id, wTheme::prefix('rating'));
		$meta_key = wTheme::prefix('rating');
		if ($this->save_meta_data($post_id, $meta_key)) {
			$data = stripslashes_deep($_POST['data'][$meta_key]);
			$rate = $votes = $stars = 0;
			for ($i = 1; $i <= 5; $i++) {
				$votes += $data["{$meta_key}_{$i}_stars"];
				$stars += ($data["{$meta_key}_{$i}_stars"] * $i);
			}
			if ($votes > 0) {
				$rate = round($stars / $votes, 2);
			}
			update_post_meta($post_id, "{$meta_key}_votes", $votes);
			update_post_meta($post_id, "{$meta_key}_rate", $rate);
		}
	}

	function meta_box_rating($post) {
		$meta_key = wTheme::prefix('rating');
		$this->nonce_field($meta_key);
		$data = self::get_all_meta($post->ID);
		?>
		<?php for ($i = 1; $i <= 5; $i++) { ?>
			<?php
			if (!isset($data["{$meta_key}_{$i}_stars"])) {
				$data["{$meta_key}_{$i}_stars"] = 0;
			}
			?>
			<p>
				<label for="<?php $this->field_id("{$meta_key}_{$i}_stars", $meta_key); ?>"><?php printf(wTheme::__('%s stars'), $i); ?></label><br/>
				<input type="number" step="1" min="0"
					   name="<?php $this->field_name("{$meta_key}_{$i}_stars", $meta_key); ?>"
					   value="<?php echo esc_attr(@$data["{$meta_key}_{$i}_stars"]); ?>"
					   id="<?php $this->field_id("{$meta_key}_{$i}_stars", $meta_key); ?>" class="small-text"/>
			</p>
		<?php } ?>
		<?php if (isset($data["{$meta_key}_rate"])) { ?>
			<p>
				<?php printf(wTheme::__('Rating %s / %s'), self::get_rate_format($data["{$meta_key}_rate"]), $data["{$meta_key}_votes"]); ?>
			</p>
		<?php } ?>
		<?php
	}

	static function get_rate_format($rate) {
		return number_format($rate, 2, ',', '.');
	}

	function meta_box_product_schema_settings($post) {
		$meta_key = wTheme::prefix('product_schema_settings');
		$this->nonce_field($meta_key);
		$data = $this->get_all_meta($post->ID, true);
		$data = @$data['product_schema_settings'];
		if (empty($data['currency']))
			@$data['currency'] = 'DKK';
		?>
		<p>
			<?php $field = 'use_product_schema'; ?>
			<input type="hidden" name="<?php $this->field_name($field, $meta_key); ?>" value="0" />
			<label><input type="checkbox" name="<?php $this->field_name($field, $meta_key); ?>" value="1" <?php checked(@$data[$field], '1'); ?> id="<?php $this->field_id($field, $meta_key); ?>" /> <?php wTheme::_e('Use product schema'); ?></label>
		</p>
		<div id="<?php echo $meta_key.'-wrap'; ?>" style="display: none;">
			<div>
				<p style="display: inline-block; width: 48%; margin-right: 1%;vertical-align: top;">
					<?php $field = 'price'; ?>
					<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Price'); ?></label><br />
					<input type="number" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" class="large-text" />
				</p>
				<p style="display: inline-block; width: 48%; margin-right: 1%;vertical-align: top;">
					<?php $field = 'currency'; ?>
					<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Currency'); ?></label><br />
					<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" class="large-text" />
				</p>
			</div>
			<div>
				<p style="display: inline-block; width: 48%; margin-right: 1%;vertical-align: top;">
					<?php $field = 'product_name'; ?>
					<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Name'); ?></label><br />
					<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" class="large-text" />
				</p>
				<p style="display: inline-block; width: 48%; margin-right: 1%;vertical-align: top;">
					<?php $field = 'brand'; ?>
					<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Brand'); ?></label><br />
					<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" class="large-text" />
				</p>
			</div>
			<p>
				<?php $field = 'product_description'; ?>
				<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Description'); ?></label><br />
				<textarea style="width: 99%;" name="<?php $this->field_name($field, $meta_key); ?>" id="<?php $this->field_id($field, $meta_key); ?>" class="code" cols="80" rows="10"><?php echo esc_textarea(@$data[$field]); ?></textarea>
			</p>
			<p>
				<?php $field = 'product_sku'; ?>
				<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('SKU'); ?></label><br />
				<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" class="large-text" />
			</p>
			<p>
				<?php $field = 'product_image'; ?>
				<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Image'); ?></label><br />
				<?php echo wTheme::get_media_popup_field($this->field_name($field, $meta_key, true), @$data[$field]); ?>
			</p>
			<hr />
			<h3><?php wTheme::_e('Review list'); ?></h3>
			<div class="review_wrap">
				<?php
					$reviewSection = 'review';
					$reviews = @$data[$reviewSection];
				?>
				<div class="review_list">
					<?php $reviewsIndex = 0; ?>
					<?php if (!empty($reviews)) { ?>
						<?php $i = 0; ?>
						<?php foreach ($data[$reviewSection] as $reviewsIndex=>$review) { ?>
							<div class="item">
								<h4>
									<?= wTheme::__('Review %s', ++$i); ?>
									<a class="delete_review" href="#"><?php wTheme::_e('Remove'); ?></a>
								</h4>
								<p>
									<?php $field = 'description'; $fieldName = "{$reviewSection}.{$reviewsIndex}.{$field}"; $id = $this->field_id("{$reviewSection}.{$reviewsIndex}.{$field}", $meta_key, true); ?>
									<label for="<?php $this->field_id($id, $meta_key); ?>"><?php wTheme::_e('Review body'); ?></label><br />
									<textarea style="width: 99%;" name="<?php $this->field_name($fieldName, $meta_key); ?>" id="<?= $id; ?>" class="code" cols="80" rows="6"><?php echo esc_textarea(@$review[$field]); ?></textarea>
								</p>
								<p>
									<?php $field = 'author_name'; $fieldName = "{$reviewSection}.{$reviewsIndex}.{$field}"; $id = $this->field_id("{$reviewSection}.{$reviewsIndex}.{$field}", $meta_key, true); ?>
									<label for="<?php $this->field_id($fieldName, $meta_key); ?>"><?php wTheme::_e('Author name'); ?></label><br />
									<input type="text" name="<?php $this->field_name($fieldName, $meta_key); ?>" value="<?= esc_attr(@$review[$field]); ?>" id="<?= $id; ?>" class="large-text" />
								</p>
								<p>
									<?php $field = 'date'; $fieldName = "{$reviewSection}.{$reviewsIndex}.{$field}"; $id = $this->field_id("{$reviewSection}.{$reviewsIndex}.{$field}", $meta_key, true); ?>
									<label for="<?php $this->field_id($fieldName, $meta_key); ?>"><?php wTheme::_e('Date published'); ?></label><br />
									<input type="text" name="<?php $this->field_name($fieldName, $meta_key); ?>" value="<?= esc_attr(@$review[$field]); ?>" id="<?= $id; ?>" class="large-text datepicker" />
								</p>
								<p>
									<?php $field = 'rating'; $fieldName = "{$reviewSection}.{$reviewsIndex}.{$field}"; $id = $this->field_id("{$reviewSection}.{$reviewsIndex}.{$field}", $meta_key, true); ?>
									<label for="<?php $this->field_id($fieldName, $meta_key); ?>"><?php wTheme::_e('Rating value'); ?></label><br />
									<input type="number" name="<?php $this->field_name($fieldName, $meta_key); ?>" value="<?= esc_attr(@$review[$field]); ?>" id="<?= $id; ?>" class="large-text" min="1" max="5" />
								</p>
							</div>
						<?php } ?>
						<?php $reviewsIndex++; ?>
					<?php } ?>
				</div>
				<script type="text/template" class="review_item">
					<div class="item">
						<h4>
							<?php wTheme::_e('New Review'); ?>
							<a class="delete_review" href="#"><?php wTheme::_e('Remove'); ?></a>
						</h4>
						<p>
							<?php $field = 'description'; $fieldName = $reviewSection.'.{ITEM_INDEX}.'.$field; ?>
							<label for="<?php $this->field_id($fieldName, $meta_key); ?>"><?php wTheme::_e('Review body'); ?></label><br />
							<textarea style="width: 99%;" name="<?php $this->field_name($fieldName, $meta_key); ?>" id="<?php $this->field_id($fieldName, $meta_key); ?>" class="code" cols="80" rows="6"></textarea>
						</p>
						<p>
							<?php $field = 'author_name'; $fieldName = $reviewSection.'.{ITEM_INDEX}.'.$field; ?>
							<label for="<?php $this->field_id($fieldName, $meta_key); ?>"><?php wTheme::_e('Author name'); ?></label><br />
							<input type="text" name="<?php $this->field_name($fieldName, $meta_key); ?>" value="" id="<?php $this->field_id($fieldName, $meta_key); ?>" class="large-text" />
						</p>
						<p>
							<?php $field = 'date'; $fieldName = $reviewSection.'.{ITEM_INDEX}.'.$field; ?>
							<label for="<?php $this->field_id($fieldName, $meta_key); ?>"><?php wTheme::_e('Date published'); ?></label><br />
							<input type="text" name="<?php $this->field_name($fieldName, $meta_key); ?>" value="" id="<?php $this->field_id($fieldName, $meta_key); ?>" class="large-text datepicker" />
						</p>
						<p>
							<?php $field = 'rating'; $fieldName = $reviewSection.'.{ITEM_INDEX}.'.$field; ?>
							<label for="<?php $this->field_id($fieldName, $meta_key); ?>"><?php wTheme::_e('Rating value'); ?></label><br />
							<input type="number" name="<?php $this->field_name($fieldName, $meta_key); ?>" value="" id="<?php $this->field_id($fieldName, $meta_key); ?>" class="large-text" min="1" max="5" />
						</p>
					</div>
				</script>
				<div><a class="button button-set review_add" href="#"><?php wTheme::_e('Add review'); ?></a></div>
			</div>
		</div>
		<style>
			.review_list .item {
				display: inline-block; width: 100%; margin-right: 20px; max-width: 320px; vertical-align: top;
			}
			.delete_review {
				float: right;
				font-weight: normal;
				color: red;
			}
		</style>
		<script>
			jQuery(function () {
				var $checkbox = jQuery('input#<?php $this->field_id('use_product_schema', $meta_key); ?>');
				var $fields_wrap = jQuery('#<?php echo $meta_key.'-wrap'; ?>');
				$checkbox.change(function () {
					$fields_wrap.toggle(jQuery(this).prop('checked'));
				}).change();

				var $reviewList = jQuery('.review_list');
				var $reviewItem = jQuery('.review_item');
				var $reviewAdd = jQuery('.review_add');
				var index = <?= $reviewsIndex; ?>;
				$reviewAdd.on('click', function () {
					var $item = $reviewItem.html().replace(/{ITEM_INDEX}/gi, index++);
					$reviewList.append($item);
					$reviewList.find('.item').last().find('.datepicker').datepicker();
					return false;
				});
				$reviewList.on('click', '.delete_review', function () {
					jQuery(this).closest('.item').remove();
					return false;
				});
				jQuery('.datepicker').datepicker();
			});
		</script>
		<?php
	}

	function meta_box_additional_fields($post) {
		$meta_key = wTheme::prefix('additional_fields');
		$this->nonce_field($meta_key);
		$data = self::get_all_meta($post->ID);
		wp_enqueue_script('wp-color-picker');
		wp_enqueue_style('wp-color-picker');
		?>
		<p>
			<?php $field = 'overlay_color'; ?>
			<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Overlay color'); ?></label><br />
			<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" class="color_picker" />
		</p>
		<p>
			<?php $field = 'overlay_value'; ?>
			<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Overlay color percentage'); ?></label><br />
			<input type="number" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" class="small-text" min="0" max="100" /><br />
			<span class="description"><?= wTheme::__('100 % equal solid color without opacity.'); ?></span>
		</p>
		<script>
			jQuery(function() {
				jQuery('.color_picker').wpColorPicker();
			});
		</script>
			<p>
				<?php
					$args = array(
//						'role'    => 'contributor',
//						'orderby' => 'user_nicename',
//						'order'   => 'ASC'
					);
					$users = get_users($args);
					if (!empty($users)){
						?>
						<label for="<?php $this->field_id('moderator_id', $meta_key); ?>"><?php wTheme::_e('Reviewed by'); ?></label><br />
						<select name="<?php $this->field_name('moderator_id', $meta_key); ?>" id="<?php $this->field_id('moderator_id', $meta_key); ?>">
							<option value="0" <?php selected(0, @$data['moderator_id']); ?>><?php wTheme::_e('None'); ?></option>
							<?php foreach ($users as $user) { ?>
								<?php $display_name =  $user->display_name ? $user->display_name : $user->user_nicename; ?>
								<option value="<?php echo esc_attr($user->ID); ?>" <?php selected($user->ID, @$data['moderator_id']); ?>><?php echo $display_name; ?></option>
							<?php } ?>
						</select>
						<?php
					}
				?>
			</p>
			<h4><?php wTheme::_e('Reviewed'); ?>:</h4>
			<p>
				<?php wp_editor(@$data['reviewed_by'], 'reviewed_by', array('textarea_name'=>$this->field_name('reviewed_by', $meta_key, true))); ?>
			</p>
		<?php
	}

	function meta_box__short_description($post) {
		$meta_key = wTheme::prefix('short_description');
		$this->nonce_field($meta_key);
		$data = self::get_all_meta($post->ID);
		$field = 'short_description';
		wp_editor(@$data[$field], $field, array('textarea_name'=>$this->field_name($field, $meta_key, true)));
	}

	function meta_box__featured_bg_color($post) {
		$meta_key = wTheme::prefix('featured_bg');
		$this->nonce_field($meta_key);
		wp_enqueue_script('wp-color-picker');
		wp_enqueue_style('wp-color-picker');
		$data = get_post_meta($post->ID, $meta_key, true);
		?>
		<p>
			<label for="<?php $this->field_id('color', $meta_key); ?>"><?php wTheme::_e('Color'); ?></label><br />
			<input type="text" name="<?php $this->field_name('color', $meta_key); ?>" value="<?php echo esc_attr(@$data['color']); ?>" id="<?php $this->field_id('color', $meta_key); ?>" class="color_picker" />
		</p>
		<p>
			<?php $field = 'is_use_overlay'; ?>
			<input type="hidden" name="<?php $this->field_name($field, $meta_key); ?>" value="0" />
			<label><input type="checkbox" name="<?php $this->field_name($field, $meta_key); ?>" value="1" <?php checked(@$data[$field], '1'); ?> id="<?php $this->field_id($field, $meta_key); ?>" /> <?php wTheme::_e('Turn on 25% overlay'); ?></label>
		</p>
		<script>
			jQuery(function() {
				jQuery('#wtheme_featured_bg_color .color_picker').wpColorPicker();
			});
		</script>
		<?php
	}
}