<?php

class wPage extends wCustomPostType {

	function action__add_meta_boxes($post) {
		parent::action__add_meta_boxes($post);
		$post_type = $this->post_type();

		add_meta_box(wTheme::prefix('map_settings'), wTheme::__('Map settings'), array($this, 'meta_box__map_settings'), $post_type, 'advanced', 'low');
		add_meta_box(wTheme::prefix('short_description'), wTheme::__('Short description'), array($this, 'meta_box__short_description'), $post_type, 'advanced', 'low');
		add_meta_box(wTheme::prefix('schema_author'), wTheme::__('Schema author'), array($this, 'meta_box__schema_author'), $post_type, 'side', 'low');
		add_meta_box(wTheme::prefix('additional_fields'), wTheme::__('Additional fields'), array($this, 'meta_box__additional_fields'), $post_type, 'side', 'low');
	}

	function meta_box__map_settings($post) {
		$meta_key = wTheme::prefix('map_settings');
		$map_settings = get_post_meta($post->ID, $meta_key, true);
		$this->nonce_field($meta_key);
		?>
		<p>
			<?php $field = 'embed_code'; $value = @$map_settings[$field]; ?>
			<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Embed code'); ?></label><br />
			<textarea name="<?php $this->field_name($field, $meta_key); ?>" id="<?php $this->field_id($field, $meta_key); ?>" rows="5" cols="80" class="widefat"><?php echo esc_textarea($value); ?></textarea>
		</p>
		<p>
			<?php $field = 'position'; $value = @$map_settings[$field]; ?>
			<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Position'); ?></label><br />
			<select name="<?php $this->field_name($field, $meta_key); ?>" id="<?php $this->field_id($field, $meta_key); ?>">
				<option value="top" <?php selected($value, 'top'); ?>><?php wTheme::_e('Top'); ?></option>
				<option value="right" <?php selected($value, 'right'); ?>><?php wTheme::_e('Right'); ?></option>
				<option value="bottom" <?php selected($value, 'bottom'); ?>><?php wTheme::_e('Bottom'); ?></option>
				<option value="left" <?php selected($value, 'left'); ?>><?php wTheme::_e('Left'); ?></option>
			</select>
		</p>
		<script>
			(function(){
				var $metaBoxMapSettings = jQuery('#<?php echo wTheme::prefix('map_settings'); ?>');
				jQuery('#page_template').change(function() {
					$metaBoxMapSettings.toggle('page-templates/contact.php' === jQuery(this).val());
				}).change();
			})();
		</script>
	<?php
	}

	function meta_box__short_description($post) {
		$meta_key = wTheme::prefix('short_description');
		$this->nonce_field($meta_key);
		$data = self::get_all_meta($post->ID);
		$field = 'short_description';
		wp_editor(@$data[$field], $field, array('textarea_name'=>$this->field_name($field, $meta_key, true)));
	}

	function meta_box__schema_author($post) {
		$meta_key = wTheme::prefix('schema_author');
		$this->nonce_field($meta_key);
		$data = wPage::get_all_meta($post->ID, true);
		?>
		<p>
			<?php $field = 'schema_author_is_active'; $value = @$data[$field]; ?>
			<input type="hidden" name="<?php $this->field_name($field, $meta_key); ?>" value="0" />
			<label><input type="checkbox" name="<?php $this->field_name($field, $meta_key); ?>" value="1" <?php checked(@$value, '1'); ?> /> <?php wTheme::_e('Activate'); ?></label>
		</p>
		<p style="display: none;">
			<?php $field = 'schema_author_user_id'; $value = @$data[$field]; ?>
			<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Select author'); ?></label><br />
			<?php
				$args = array(
					'name' => $this->field_name($field, $meta_key, true),
					'id' => $this->field_id($field, $meta_key, true),
					'selected' => $value,
				);
				wp_dropdown_users($args);
			?>
		</p>
		<script>
			(function() {
				var $metaBoxSchemaAuthor = jQuery('#<?php echo wTheme::prefix('schema_author'); ?>');
				$metaBoxSchemaAuthor.find('input:checkbox').change(function () {
					var $this = jQuery(this);
					$this.closest('p').next().toggle($this.prop('checked'));
				}).change();
			})();
		</script>
		<?php
	}

	function action__save_post($post_id) {
		parent::action__save_post($post_id);
		$this->save_meta_data($post_id, wTheme::prefix('map_settings'), false, true);
		$this->save_meta_data($post_id, wTheme::prefix('short_description'));
		$this->save_meta_data($post_id, wTheme::prefix('schema_author'), true, true);
		$this->save_meta_data($post_id, wTheme::prefix('additional_fields'));
	}

	function meta_box__additional_fields($post) {
		$meta_key = wTheme::prefix('additional_fields');
		$this->nonce_field($meta_key);
		$data = wPage::get_all_meta($post->ID, true);
		wp_enqueue_script('wp-color-picker');
		wp_enqueue_style('wp-color-picker');
		?>
		<p>
			<?php $field = 'before_title_label'; ?>
			<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Before title label'); ?></label><br />
			<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" />
		</p>
		<p>
			<?php $field = 'overlay_color'; ?>
			<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Overlay color'); ?></label><br />
			<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" class="color_picker" />
		</p>
		<p>
			<?php $field = 'overlay_value'; ?>
			<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Overlay color percentage'); ?></label><br />
			<input type="number" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" class="small-text" min="0" max="100" /><br />
			<span class="description"><?= wTheme::__('100 % equal solid color without opacity.'); ?></span>
		</p>
		<script>
			jQuery(function() {
				jQuery('.color_picker').wpColorPicker();
			});
		</script>
		<?php
	}
}