<?php
/**
 * Version: 0.1.3
 */
class wCustomPostType {

	//static $post_type; Must be defined in children to use

	protected $_post_type = '';

	private static $post_types = array();

	private static $internal_post_types = array('page', 'post', 'attachment', 'revision', 'nav_menu_item');

	function __construct($post_type) {
		if (empty($post_type))
			throw new Exception('Empty post type');

		if (in_array($post_type, self::$post_types))
			throw new Exception("Post type '{$post_type}' already registered");

		$this->post_type($post_type);
		$this->add_hooks();
	}

	function add_hooks() {
		$post_type = $this->post_type();
		//Fix updated page multiple times
		add_action('init', array($this, 'action__init'));
		add_action("add_meta_boxes_{$post_type}", array($this, 'action__add_meta_boxes'));
		add_action('save_post', array($this, 'action__save_post'));
		if (!in_array($post_type, self::$internal_post_types))
			remove_action('wp_head', 'adjacent_posts_rel_link_wp_head', 10);

		//TODO add default sorting 'orderby' => array('menu_order' => 'ASC', 'date' => 'DESC')
	}

	function action__init() {
		if (!in_array($this->post_type(), self::$internal_post_types))
			$this->register_post_type();
	}

	function action__add_meta_boxes($post) {}

	function action__save_post($post_id) {}

	function get_labels($singular = '', $plural = '') {
		if (!empty($singular) && !empty($plural)) {
			$singular = wTheme::__($singular);
			$plural = wTheme::__($plural);
		} else {
			$singular = _x('Post', 'post type singular name');
			$plural = _x('Posts', 'post type general name');
		}

		return array(
			'name' => $plural,
			'singular_name' => $singular,
			'add_new_item' => sprintf(wTheme::__('Add New %s'), $singular),
			'edit_item' => sprintf(wTheme::__('Edit %s'), $singular),
			'new_item' => sprintf(wTheme::__('New %s'), $singular),
			'view_item' => sprintf(wTheme::__('View %s'), $singular),
			'search_items' => sprintf(wTheme::__('Search %s'), $plural),
			'not_found' => sprintf(wTheme::__('No %s found.'), $plural),
			'not_found_in_trash' => sprintf(wTheme::__('No %s found in Trash.'), $plural),
			'all_items' => sprintf(wTheme::__('All %s'), $plural),
		);
	}

	function get_label($key) {
		$post_type = get_post_type_object($this->post_type());
		return $post_type->labels->{$key};
	}

	function register_post_type($args = array()) {
		$post_type = $this->post_type();
		if (post_type_exists($post_type))
			throw new Exception("Post type '{$post_type}' already registered");

		$defaults = array(
			'public' => true,
			'show_ui' => true,
			'hierarchical' => false,
			'capability_type' => 'post',
			'supports' => array('title', 'editor', 'thumbnail', 'page-attributes'),
			'rewrite' => false,
		);

		if ($labels = $this->get_labels())
			$defaults['labels'] = $labels;

		$args = wp_parse_args($args, $defaults);
		register_post_type($post_type, $args);
	}

	function post_type($post_type = '') {
		if (!empty($post_type)) {
			$this->_post_type = $post_type;
			self::$post_types []= $post_type;

			if (property_exists(get_called_class(), 'post_type'))
				static::$post_type = $post_type;
		}

		return $this->_post_type;
	}

	function field_name($field_name, $meta_key, $return = false) {
		$field_name = str_replace('.', '][', $field_name);
		$field = "data[{$meta_key}][{$field_name}]";
		if (!$return)
			echo $field;

		return $field;
	}

	function field_id($field_name, $meta_key, $return = false) {
		$field_id = str_replace('.', '_', "{$meta_key}_{$field_name}");
		if (!$return)
			echo $field_id;

		return $field_id;
	}

	function nonce_field($name = '_wpnonce', $action = 'save', $referer = true, $echo = true) {
		$post_type = $this->post_type();
		return wp_nonce_field("{$post_type}-{$name}-{$action}", "{$post_type}-{$name}_nonce", $referer, $echo);
	}

	function can_save_meta_data($post_id, $meta_key, $action = 'save') {
		if ((defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) || wp_is_post_revision($post_id))
			return false;

		$post_type = $this->post_type();
		if (!wp_verify_nonce(@$_POST["{$post_type}-{$meta_key}_nonce"], "{$post_type}-{$meta_key}-{$action}"))
			return false;

		$capability = 'page' === $post_type ? 'edit_page' : 'edit_post';
		if (!current_user_can($capability, $post_id))
			return false;

		if (empty($_POST['data'][$meta_key]))
			return false;

		return true;
	}

	function save_meta_data($post_id, $meta_key, $save_in_multiple = true, $use_prefix = false) {
		if (!$this->can_save_meta_data($post_id, $meta_key))
			return false;

		$data = stripslashes_deep($_POST['data'][$meta_key]);
		if ($save_in_multiple) {
			foreach ($data as $field=>$value)
				update_post_meta($post_id, $use_prefix ? wTheme::prefix($field) : $field, $value);
		} else {
			update_post_meta($post_id, $use_prefix ? $meta_key : wTheme::remove_prefix($meta_key), $data);
		}

		return true;
	}

	static function get_meta($post_id, $key = '', $single = true) {
		return get_post_meta($post_id, wTheme::prefix($key), $single);
	}

	static function get_all_meta($post_id, $is_remove_prefix = false, $single = true) {
		$data = array();
		$meta_data = get_post_meta($post_id, '', $single);
		if (empty($meta_data))
			return $data;

		foreach ($meta_data as $meta_key=>$meta_value) {
			if ($is_remove_prefix)
				$meta_key = wTheme::remove_prefix($meta_key);
			if ($single)
				$data[$meta_key] = maybe_unserialize($meta_value[0]);
			else
				$data[$meta_key] = array_map('maybe_unserialize', $meta_value);
		}

		return $data;
	}
}