<?php
class wAvatar {

	static $subdir = '/avatars';

	static $meta_key = 'avatar_image_id';

	static function construct() {
		static::$meta_key = wTheme::prefix(static::$meta_key);
		add_action('after_switch_theme', array(__CLASS__, 'action__activate_theme'));

		if ('upload.php'===@$GLOBALS['pagenow'] && is_admin())
			add_action('pre_get_posts', array(__CLASS__, 'action__pre_get_posts'));
		elseif ('query-attachments'===@$_REQUEST['action'] && wp_doing_ajax())
			add_filter('ajax_query_attachments_args', array(__CLASS__, 'filter__ajax_query_attachments_args'));
	}

	static function action__activate_theme() {
		$upload_dir = static::get_upload_dir();
		if (!$upload_dir || !empty($upload_dir['error']))
			return;

		wp_mkdir_p($upload_dir['basedir']);
	}

	/**
	 * @param WP_Query $query
	 */
	static function action__pre_get_posts($query) {
		if (!$query->is_main_query())
			return;

		$query->query_vars['meta_query'] []= static::avatar_filter_conditions();
	}

	static function filter__ajax_query_attachments_args($args) {
		$args['meta_query'] []= static::avatar_filter_conditions();
		return $args;
	}

	static function avatar_filter_conditions() {
		return array(array(
			'relation' => 'OR',
			array('key'=>'type', 'value'=>'avatar', 'compare'=>'!='),
			array('key'=>'type', 'compare'=>'NOT EXISTS'),
		));
	}

	static function get_avatar($user_id, $image_size) {
		$size = wp_get_additional_image_sizes()[$image_size];
		$size = min($size['width'], $size['height']);

		add_filter('pre_get_avatar_data', array(__CLASS__, 'filter__pre_get_avatar_data'), 10, 2);
		$avatar = get_avatar($user_id, $size, '', '', compact('image_size'));
		remove_filter('pre_get_avatar_data', array(__CLASS__, 'filter__pre_get_avatar_data'));

		return $avatar;
	}

	static function filter__pre_get_avatar_data($args, $user_id) {
		$user = get_user_by('id', absint($user_id));
		if ($user) {
			$size = $args['size'];
			$image_size = $args['image_size'];
			if ($args['width']*2==$size || $args['height']*2==$size) {
				$retina_image_size = $image_size.'_2x';
				if (!empty(wp_get_additional_image_sizes()[$retina_image_size]))
					$image_size = $retina_image_size;
			}

			$avatar_image_id = get_user_meta($user->ID, static::$meta_key, true);
			list($url,,) = wp_get_attachment_image_src($avatar_image_id, $image_size);
			if ($url)
				$args['url'] = $url;
			else if ($facebook_id = get_user_meta($user->ID, 'facebook_id', true))
				$args['url'] = "https://graph.facebook.com/{$facebook_id}/picture?type=square&width={$size}&height={$size}";
		}

		return $args;
	}

	static function update_avatar($user_id, $field) {
		$current_attachment_id = get_user_meta($user_id, static::$meta_key, true);

		$attachment_id = self::handle_upload($field, $user_id);
		update_user_meta($user_id, static::$meta_key, $attachment_id);

		if ('avatar'===get_post_meta($current_attachment_id, 'type', true))
			wp_delete_attachment($current_attachment_id, true);

		return $attachment_id;
	}

	static function handle_upload($field, $user_id=null) {
		require_once ABSPATH . 'wp-admin/includes/file.php';
		require_once ABSPATH . 'wp-admin/includes/media.php';
		require_once ABSPATH . 'wp-admin/includes/image.php';

		$mimes = array('jpg'=>'image/jpg','jpeg'=>'image/jpeg', 'gif'=>'image/gif', 'png'=>'image/png');
		add_filter('upload_dir', array(__CLASS__, 'filter__upload_dir'));
		$_POST['action'] = 'wp_handle_upload';
		$attachment_id = media_handle_upload($field, 0, array(), array('mimes'=>$mimes));
		remove_filter('upload_dir', array(__CLASS__, 'filter__upload_dir'));

		if (is_wp_error($attachment_id))
			throw new Exception($attachment_id->get_error_message());

		update_post_meta($attachment_id, 'type', 'avatar');
		if ($user_id)
			update_post_meta($attachment_id, 'user_id', $user_id);

		return $attachment_id;
	}

	static function filter__upload_dir($upload_dir) {
		return static::get_upload_dir(compact('upload_dir'));
	}

	static function get_upload_dir($args=array()) {
		$upload_dir = isset($args['upload_dir']) ? $args['upload_dir'] : wp_get_upload_dir();
		if (!$upload_dir || !empty($upload_dir['error']))
			return $upload_dir;

		$upload_dir['subdir'] = static::$subdir . $upload_dir['subdir'];
		$upload_dir['path'] = $upload_dir['basedir'] . $upload_dir['subdir'];
		$upload_dir['url'] = $upload_dir['baseurl'] . $upload_dir['subdir'];

		return $upload_dir;
	}
}
wAvatar::construct();