function wtheme_attach_media_popup($button, callback) {
	var media_frame;

	$button.on('click', function(event) {
		event.preventDefault();
		if (media_frame) {
			media_frame.open();
			return;
		}

		var title = $button.data('uploader_button_text') || $button.text() || $button.val();
		media_frame = wp.media.frames.file_frame = wp.media({
			title: title,
			button: {
				text: title
			},
			multiple: false
		});

		media_frame.on('select', function() {
			var attachment = media_frame.state().get('selection').first().toJSON();
			callback($button, attachment, media_frame);
		});
		media_frame.open();
		return false;
	});
}

function wtheme_media_popup_attachment_src($button, $input) {
	wtheme_attach_media_popup($button, function($button, attachment) {
		$input.val(attachment.url);
	});
}

function wtheme_media_popup_attachment_button($set_button, $remove_button) {
	wtheme_attach_media_popup($set_button, function($button, attachment, media_frame) {
		var $parent = $button.parent();
		var $input = $parent.find('input');

		var $img = jQuery('<img />');
		var $span = jQuery('<span />').text(attachment.filename);
		$img.attr({'src':attachment.icon});

		if (attachment.sizes) {
			var image_size = $button.data('image_size');
			var thumbnail = attachment.sizes.thumbnail || attachment.sizes.full;
			if (image_size && attachment.sizes[image_size])
				thumbnail = attachment.sizes[image_size];
			$img.attr({'src':thumbnail.url, 'width':thumbnail.width, 'height':thumbnail.height});
			$span = ''
		}

		$input.val(attachment.id);
		$parent.find('.img-wrap').empty().append($img).append($span);
		$parent.find('img').animate({opacity: 0}, 0).animate({opacity: 1}, 1000);
		$parent.find('.button-remove').show();
	});

	$remove_button.on('click', function() {
		var $this = jQuery(this);
		var $parent = $this.parent();
		var $input = $parent.find('input');

		$input.val('');
		$parent.find('.img-wrap').empty();
		$this.hide();
		return false;
	});
}
