<?php wp_enqueue_script('jquery-ui-dialog'); ?>
<div id="search_popup" style="display: none;">
	<form role="search" method="get" class="search-form" action="">
		<label class="search-field general"><input type="text" placeholder="<?php wTheme::_e('Search') ?>..." value="<?php echo get_search_query() ?>" name="s" /></label>
		<div class="radio input clear">
			<label><input type="radio" name="_search_by" value="case" checked="checked" data-name="search" data-url="<?php echo wTheme::get_url_by_template('cases-list'); ?>" /><?php wTheme::_e('Cases'); ?></label>
			<label><input type="radio" name="_search_by" value="other" data-name="s" data-url="<?php echo home_url( '/' ); ?>" /><?php wTheme::_e('Other content'); ?></label>
		</div>
		<span class="button_submit"><input type="submit" class="search-submit" value="" /></span>
	</form>
<!--	<div class="search_form"></div>-->
</div>
<script>
	jQuery(function(){
		var $popup = jQuery('#search_popup');
		$popup.dialog({
			autoOpen: false,
			draggable: false,
			modal: true,
			width: 'auto',
			closeOnEscape: true,
			resizable: false,
			create: function(event, ui) {
				var maxWidth = '720px';
				if ($popup.data('max-width'))
					maxWidth = $popup.data('max-width');
				jQuery(this).css('maxWidth', maxWidth);
			},
			open: function() {
				var $widget = jQuery(this).dialog('widget');
				var $overlay = jQuery('.ui-widget-overlay');

				$overlay.hide().fadeIn(300);
				$widget.hide().fadeIn(600);

				jQuery(document).on('click', '.ui-widget-overlay', function() {
					$widget.fadeOut(300);
					$overlay.fadeOut(600);
					$popup.dialog('close');
				});
			}
		});

		jQuery('.site_header_wrap a.open_search').on('click', function() {
			$popup.dialog('open');
			return false;
		});

		var $form = $popup.find('form');
		var $search = $popup.find('.search-field input');
		$form.find('input:radio').change(function () {
			if (this.checked) {
				$search.prop('name', jQuery(this).data('name'));
				$form.prop('action', jQuery(this).data('url'));
			}
		}).change();

		$form.submit(function() {
			$form.find('input:radio').prop('name', '');
		});

		//$popup.dialog('open');
	});
</script>