<?php
/**
 * Template Name: Events list
 * Layout: right-sidebar
 */
?>
<div class="events_list_wrap">
	<div class="left_wrap">
		<header class="entry_header">
			<h1 class="entry_title info"><?php the_title(); ?></h1>
		</header>
		<?php
		$query_args = array(
			'post_type' => wEvent::$post_type,
			'meta_query' => array(
				array(
					'key' => 'start_date',
					'value' => current_time('mysql'),
					'compare' => '>=',
					'type' => 'DATETIME',
				),
			),
			'meta_key' => 'start_date',
			'orderby' => 'meta_value',
			'order' => 'ASC',
			'posts_per_page' => -1,
		);
		$upcoming_events = wEvent::wp_query($query_args);
		if ($upcoming_events->have_posts()) {
			?>
			<ul class="list">
				<?php
				while ($upcoming_events->have_posts()) { $upcoming_events->the_post();
					echo wTheme::part('event');
				}
				?>
			</ul>
			<?php
		}
		wp_reset_query();
		?>
	</div>
</div>