<?php
/**
 * Template Name: Cases list
 * Layout: full-width
 */
if (wCase::is_ajax()) {
	if (!isset($args))
		$args = array();

	$response = wCase::get_items_response($args);
	echo json_encode($response);
	die;
}
wp_enqueue_script('jquery-ui-selectmenu');
global $wCaseCategory;
$parent_cats = $wCaseCategory->get_terms(array('parent'=>0));
?>
<div class="cases_list_wrap">
	<div class="filters_wrap">
		<form class="filters" action="" method="post">
			<input type="hidden" name="is_changed" value="0" />
			<div class="order">
				<select id="order" name="order" class="order_menu">
					<?php foreach (wCase::$order_options as $value=>$label) { ?>
					<option value="<?php echo $value; ?>"><?php echo wTheme::__($label); ?></option>
					<?php } ?>
				</select>
			</div>
			<div class="search">
				<label for="search"><?php wTheme::_e('Search here'); ?></label>
				<input type="search" name="search" value="<?php echo @$_REQUEST['search']; ?>" placeholder="<?php wTheme::_e('Free text search'); ?>..." />
			</div>
			<?php if (!empty($parent_cats)) { ?>
			<div class="categories">
				<ul>
					<?php foreach ($parent_cats as $parent_cat) { ?>
					<li>
						<a class="category_title" href="#"><?php echo $parent_cat->name; ?></a>
						<div class="sub_menu">
							<?php $term_description = term_description($parent_cat); ?>
							<?php if ($term_description) { ?>
							<div class="category_description">
								<?php echo $term_description; ?>
							</div>
							<?php } ?>
							<?php $cats = $wCaseCategory->get_terms(array('parent'=>$parent_cat->term_id)); ?>
							<ul class="sub_category">
								<?php foreach ($cats as $cat) { ?>
									<li class="input checkbox"><label><input type="checkbox" name="term_ids[]" value="<?php echo $cat->term_id; ?>" /><?php echo $cat->name; ?></label></li>
								<?php } ?>
							</ul>
						</div>
					</li>
					<?php } ?>
				</ul>
			</div>
			<?php } ?>
		</form>
	</div>
	<div class="right_wrap">
		<header class="entry_header">
			<h1 class="entry_title info"><?php the_title(); ?></h1>
		</header>
		<div class="list"></div>
		<div class="loading_animation">
			<span class="loading_icon"></span>
			<span><?php wTheme::_e('Loading...'); ?></span>
		</div>
	</div>
</div>
<script>
	jQuery(function() {
		jQuery('.categories > ul > li > a').click(function() {
			var $this = jQuery(this).parent();
			if ($this.hasClass('open')) {
				$this.removeClass('open').find('>.sub_menu').slideUp(300);
			} else {
				jQuery('.categories > ul > li').not($this).removeClass('open').find('>.sub_menu').slideUp(300);
				if ($this.find('>.sub_menu')) {
					$this.find('>.sub_menu').slideDown(300);
					$this.addClass('open');
				}
			}
			return false;
		});
		jQuery('.categories > ul > li > a:first').click();

		jQuery(document).on("click", ".read_more_link", function() {
			var $description_wrap = jQuery(this).parent().find('.hidden_content');
			$description_wrap.toggleClass('open');
			jQuery(this).find('span').toggle();
			return false;
		});

		var $wrap = jQuery('.cases_list_wrap');
		var $filters_form = jQuery('.filters', $wrap);
		var is_ajax_send = false;
		var $loading = jQuery('.loading_animation');
		var $list = jQuery('.list', $wrap);
		var $found_items_text = jQuery('.right_wrap .info', $wrap);
		var $load_more = jQuery('.view_more', $wrap);
		var posts_per_page = <?php echo wCase::$ajax_posts_per_page; ?>;
		var more_post = posts_per_page;
		var offset_post = posts_per_page;
		var empty_item = '<article class="no_results"><?php wTheme::_e('Nothing found'); ?></article>';
		var $is_changed = jQuery('input[name="is_changed"]', $filters_form);

		jQuery('select', $filters_form).selectmenu({
			position: {my : "left top", at: "left bottom"},
			create: function(event, ui) {
				var $this = jQuery(this);
				if ($this.prop('class'))
					$this.selectmenu('menuWidget').closest('.ui-selectmenu-menu').addClass($this.prop('class'));
			},
			open: function(event, ui) {
				jQuery(this).selectmenu('menuWidget').closest('.ui-selectmenu-menu').width(jQuery(this).selectmenu('widget').width());
			}
		});

		jQuery('select', $filters_form).on('selectmenuchange', function() {
			$is_changed.val('1');
			ajax_filters($filters_form.attr('action'), false);
		});

		jQuery('input', $filters_form).bind('change blur', function() {
			$is_changed.val('1');
			ajax_filters($filters_form.attr('action'), false);
		});

		$load_more.find('a').click(function(){
			ajax_filters(jQuery(this).attr('href'), true);
			more_post = more_post + offset_post;
			return false;
		});

		$filters_form.submit(function() {
			jQuery('input:focus', $filters_form).blur();
			ajax_filters($filters_form.attr('action'), false);
			return false;
		});

		function ajax_filters(url, is_load_more) {
			if (true == is_ajax_send)
				return false;

			var $data = $filters_form.serialize();

			if (is_load_more) {
				$data = $data+'&is_load_more='+more_post;
			} else {
				$list.empty();
				more_post = posts_per_page;
			}

			jQuery.ajax({
				type: "POST",
				url: url,
				dataType: 'json',
				data: $data,
				beforeSend: function() {
					is_ajax_send = true;
					$wrap.addClass('loading');
					$loading.show();
				}
			}).done(function(response) {
				$loading.hide();

				$found_items_text.html(response.found_items_text);
				if (response.items) {
					jQuery(response.items).each(function(i, item) {
						jQuery(document).queue('append', function(next) {
							jQuery(item).css('opacity', 0).appendTo($list).animate({opacity: 1, queue: false}, 25, function() {
								next();
							});
						});
					});

					if (jQuery(response.items).size() === 0 || jQuery(response.items).size() < posts_per_page)
						$load_more.hide();

					if (is_load_more)
						$load_more.toggle(jQuery(response.items).size() !== 0);
				}

				if (!is_load_more && !response.items) {
					$list.append(empty_item);
					$load_more.hide();
				}

				jQuery(document).queue('append', function(next) {
					$wrap.removeClass('loading');
					is_ajax_send = false;
					wtheme_cases_height_fix();
				});
				jQuery(document).dequeue('append');
			});
		}

		ajax_filters($filters_form.attr('action'), false);
	});
</script>