jQuery(function() {
	var $link_to_image = jQuery('a').filter(function() {
		var href = jQuery(this).attr('href');
		if(href && jQuery(this).prop('rel'))
			return href.match(/\.(jpg|png|gif|jpeg)/);
	});

	wtheme_initPrettyPhoto($link_to_image);

	jQuery('.entry_content .shortcode__read_more_button').click(function() {
		var $button_wrap = jQuery(this).parent();
		$button_wrap.hide();
		$button_wrap.prev('.shortcode__hidden_content').slideDown(300);
		$button_wrap.prevAll('.shortcode__visible_content').removeClass('gradient');
		return false;
	});

	jQuery('.entry_content .shortcode_hidecontent').click(function() {
		var $this = jQuery(this);
		$this.next().show();
		jQuery('.'+$this.attr('href').substr(1)).show();
		$this.hide();
		return false;
	});

	jQuery('.entry_content .shortcode_showcontent').click(function() {
		var $this = jQuery(this);
		jQuery('.'+$this.attr('href').substr(1)).hide();
		$this.hide();
		$this.prev().show();
		return false;
	});

	jQuery('.entry_content .shortcode_question').click(function() {
		var $this = jQuery(this);
		var $answer = $this.nextAll('.shortcode_answer:first');
		$answer.slideToggle(function() {
			$this.toggleClass('expand', $answer.is(":visible"));
		});
	});

	jQuery('.entry_content .shortcode_answer:visible').each(function() {
		jQuery(this).prevAll('.shortcode_question:first').addClass('expand');
	});

	var $main_menu = jQuery('nav.main_menu');

	$main_menu.find('> .menu_button').click(function() {
		jQuery(this).parent().toggleClass('active').find('> ul').slideToggle(500);
	});
	jQuery('.main_menu ul li').hover(
		function(){
			jQuery(this).find("> .sub-menu").stop(true,false).slideDown(300);
		}, function(){
			jQuery(this).find("> .sub-menu").delay(300).stop(true,true).slideUp(0);
		}
	);

	//----- checkboxes -----//
	jQuery(document).on('change', '.checkbox input', function() {
		jQuery(this).attr('checked', this.checked);
		jQuery(this).toggleClass('checked', this.checked);
		jQuery(this).parent().toggleClass('checked', this.checked);
	});
	jQuery('.checkbox input').filter(':checked').addClass('checked').filter(':checked').parent().addClass('checked');
});

jQuery(window).on('load', function() {
	wtheme_cases_height_fix();
	if (jQuery(window).width() < 768) {
		wtheme_responsiveMenu();
	}
	jQuery(window).resize(function() {
		wtheme_cases_height_fix();
		if (jQuery(window).width() > 767) {
			wtheme_responsiveMenu();
		}
		wtheme_clickMenu();
	}).trigger('resize');
});

function wtheme_initPrettyPhoto($list) {
	$list.prettyPhoto({social_tools: false});
}

function wtheme_responsiveMenu() {
	var existingWidth = jQuery(document).data('resize-width');
	var newWidth = jQuery(document).width();
	if (existingWidth != newWidth) {
		var $main_menu = jQuery('nav.main_menu');

		if (jQuery(window).width() < 768) {
			$main_menu.removeClass('active').addClass('responsive').find('> ul').hide();
		} else {
			$main_menu.removeClass('responsive active').find('> ul').show();
		}

		if (768 <= jQuery(window).width() &&  jQuery(window).width() <= 1024) {
			var $items = $main_menu.find('> ul > li');
			var max_width = $main_menu.width();
			var width = 0;

			$items.each(function() {
				if (width + jQuery(this).outerWidth(true) >= max_width) {
					$main_menu.addClass('responsive').find('> ul').hide();
					return false;
				} else {
					$main_menu.removeClass('responsive active').find('> ul').show();
					width += jQuery(this).outerWidth(true);
				}
			});
		}

		jQuery(document).data('resize-width', newWidth);
	}
}

function wtheme_clickMenu() {
	var is_touch = (('ontouchstart' in document.documentElement) || ('ontouchstart' in window) || (navigator.maxTouchPoints > 0) || (navigator.msMaxTouchPoints > 0));
	if (is_touch && (!jQuery('.main_menu').hasClass('responsive'))) {
		jQuery('.main_menu .menu-item-has-children > a').click(function() {
			if (!jQuery(this).data('click')) {
				jQuery(this).data('click', 1).parent().addClass('active').siblings().removeClass('active').find('a').data('click', 0);
				jQuery(this).parent().siblings().find('.active').removeClass('active');
				return false;
			}
		});

		jQuery('body').click(function(e) {
			if (jQuery(e.target).parents('.main_menu').length === 0) {
				jQuery('.main_menu li').removeClass('active').find('a').data('click', 0);
			}
		});
	}
}

function wtheme_cases_height_fix() {
	var max_height = 0;
	var current_height = 0;
	jQuery('.list .case').each(function(){
		current_height = jQuery(this).height('auto').height();
		if (current_height >= max_height) {
			max_height = current_height;
		}
	}).height(max_height);
}

function wtheme_add_popup_close_handlers($popup, bind_to_overlay) {
	jQuery($popup).find('.close_popup').click(function(){
		var widget = $popup.dialog('widget');
		$popup.trigger('close_animate_started');
		widget.animate({top: -1000}, {duration: 600, complete: function() {
				$popup.dialog('close');
				jQuery('.ui-widget-overlay').fadeOut(300);
				$popup.trigger('close_animate_complete');
			}});
		return false;
	});

	if (false !==bind_to_overlay) {
		jQuery(document).on('click', '.ui-widget-overlay', function () {
			if ($popup.dialog('isOpen'))
				$popup.find('.close_popup').click();
		});
	}
}