<?php
class wEvent extends wCustomPostType {

	static $post_type;

	function get_labels($singular = '', $plural = '') {
		return parent::get_labels('Event', 'Events');
	}

	function register_post_type($args = array()) {
		$slug = 'event';
		if ($page = wTheme::get_page_by_template('events-list'))
			$slug = $page->post_name;

		parent::register_post_type(
			array(
				'rewrite' => array('slug'=>$slug, 'with_front'=>false),
			)
		);
	}

	function action__add_meta_boxes($post) {
		parent::action__add_meta_boxes($post);
		add_meta_box(wTheme::prefix('additional_fields'), wTheme::__('Additional fields'), array($this, 'meta_box__additional_fields'), $post->post_type, 'side', 'low');
	}

	function meta_box__additional_fields($post) {
		$meta_key = wTheme::prefix('additional_fields');
		$this->nonce_field($meta_key);
		$data = self::get_all_meta($post->ID);
		$this->load_datepicker();
		?>
		<p>
			<label for="<?php $this->field_id('_start_date', $meta_key); ?>"><?php wTheme::_e('Start date'); ?></label><br />
			<input type="text" name="<?php $this->field_name('_start_date', $meta_key); ?>" value="<?php echo esc_attr(@$data['_start_date']); ?>" id="<?php $this->field_id('_start_date', $meta_key); ?>" class="datepicker" />
			<input type="hidden" name="<?php $this->field_name('start_date', $meta_key); ?>" value="<?php echo esc_attr(@$data['start_date']); ?>" id="<?php $this->field_id('_start_date', $meta_key); ?>_alt" />
		</p>
		<p>
			<label for="<?php $this->field_id('_end_date', $meta_key); ?>"><?php wTheme::_e('End date'); ?></label><br />
			<input type="text" name="<?php $this->field_name('_end_date', $meta_key); ?>" value="<?php echo esc_attr(@$data['_end_date']); ?>" id="<?php $this->field_id('_end_date', $meta_key); ?>" class="datepicker" />
			<input type="hidden" name="<?php $this->field_name('end_date', $meta_key); ?>" value="<?php echo esc_attr(@$data['end_date']); ?>" id="<?php $this->field_id('_end_date', $meta_key); ?>_alt" />
		</p>
		<script>
			jQuery(function(){
				jQuery(".datepicker").each(function() {
					var $this = jQuery(this);
					var altId = '#'+$this.attr('id')+'_alt';

					$this.datepicker({
						altField: altId,
						dateFormat: 'dd-mm-yy',
						altFormat: "yy-mm-dd"
					}).bind('change paste keyup blur', function() {
						if ('' == $this.val())
							jQuery(altId).val('');
					});
				});
			});
		</script>
		<?php
	}

	function action__save_post($post_id) {
		parent::action__save_post($post_id);
		$this->save_meta_data($post_id, wTheme::prefix('additional_fields'));
	}

	function load_datepicker() {
		global $wp_scripts;

		wp_enqueue_script('jquery-ui-datepicker', false, array('jquery'));

		$version = $wp_scripts->registered['jquery-ui-datepicker']->ver;
		$base = "//ajax.googleapis.com/ajax/libs/jqueryui/{$version}";
		$theme = version_compare($version, '1.10', '<') ? 'base' : 'smoothness';
		wp_enqueue_style('jquery-ui-datepicker-css', "{$base}/themes/{$theme}/jquery-ui.min.css", false, $version);

		$locale = current(explode('_', get_locale()));
		if ('en' !== $locale)
			wp_enqueue_script('jquery-ui-datepicker-locale-js', "{$base}/i18n/jquery.ui.datepicker-{$locale}.min.js", false, $version, true);
	}
}