<?php
/**
 * Version: 0.1
 */
class wGoogleMaps {

	static function get_api_key() {
		return wThemeSettings::get_option('Integrations.GoogleMaps.api_key');
	}

	/**
	 * Return location by address
	 * @param string|array $address format: '{address}, {city}, {zip} or array($address, $city, $zip)
	 * @return array('lat'=>(float) value, 'lng'=>(float) value);
	 */
	static function get_location_by_address($address) {
		if (is_array($address))
			$address = implode(', ', $address);

		$args = array('address'=>$address);
		$api_key = self::get_api_key();
		if (!empty($api_key))
			$args['key'] = $api_key;

		$url = 'https://maps.googleapis.com/maps/api/geocode/json?'.http_build_query($args);
		$response = wp_remote_get($url);
		if (is_wp_error($response) || 200 != wp_remote_retrieve_response_code($response))
			return null;

		$response = json_decode(wp_remote_retrieve_body($response), true);

		if (!is_array($response))
			return null;

		if('OVER_QUERY_LIMIT' == $response['status']) {
			usleep(200000);
			return self::get_location_by_address($address);
		} else if ($response['status'] != 'OK') {
			return null;
		}

		return $response['results'][0]['geometry']['location'];
	}

	static function get_static_map($args = array()) {
		$latitude = $args['latitude'];
		$longitude = $args['longitude'];

		$google_map_url = "https://www.google.com/maps/dir//{$latitude},{$longitude}/@{$latitude},{$longitude},18z";
		$static_map_url = self::get_static_url($latitude, $longitude, $args);
		if (empty($static_map_url))
			return '';

		ob_start();
		?>
			<div class="static_map"><a href="<?php echo $google_map_url ?>" onclick="this.target='_blank';"><img src="<?php echo $static_map_url; ?>" alt="" /></a></div>
		<?php
		return ob_get_clean();
	}

	static function get_static_url($latitude, $longitude, $args = array()) {
		if (empty($latitude) || empty($longitude))
			return '';

		$defaults = array(
			'zoom' => 12,
			'size' => '340x340',
			'center' => "{$latitude},{$longitude}",
			'markers' => "color:red|{$latitude},{$longitude}",
		);

		if (is_admin())
			$defaults['size'] = '500x250';

		$api_key = self::get_api_key();
		if (!empty($api_key))
			$defaults['key'] = $api_key;

		$args = wp_parse_args($args, $defaults);
		return 'https://maps.googleapis.com/maps/api/staticmap?'.http_build_query($args);
	}

	static function get_location_by_coordinates_for_save($latitude, $longitude) {
		if ('' != $latitude)
			$latitude = floatval(str_replace(',', '.', $latitude));
		if ('' != $longitude)
			$longitude = floatval(str_replace(',', '.', $longitude));
		return compact('latitude', 'longitude');
	}

	static function get_location_by_address_for_save($data, $old_data) {
		$address = array();
		$latitude = @$old_data['address_latitude'];
		$longitude = @$old_data['address_longitude'];
		if ('' != @$data['address'])
			$address[] = @$data['address'];
		if ('' != @$data['city'])
			$address[] = @$data['city'];
		if ('' != @$data['zip'])
			$address[] = @$data['zip'];

		$is_changed_address = (@$old_data['address'] != @$data['address'] || @$old_data['city'] != @$data['city'] || @$old_data['zip'] != @$data['zip']);
		if (!empty($address) && $is_changed_address) {
			$address = implode(', ', $address);
			$latitude = $longitude = '';
			$location = self::get_location_by_address($address);
			if (isset($location['lat']) && isset($location['lng'])) {
				$latitude = $location['lat'];
				$longitude = $location['lng'];
			}
		} else if (empty($address)) {
			$latitude = $longitude = '';
		}

		return compact('latitude', 'longitude');
	}
}