<?php
	$time = '<time datetime="'.get_the_date('Y-m-d H:i').'">'.get_the_date('d/m/y').'</time>';
	if (is_single()) {
?>
	<article>
		<?php if (has_post_thumbnail()) { ?>
			<?php the_post_thumbnail(wTheme::prefix('featured')); ?>
		<?php } ?>
		<header class="entry_header">
			<h1 class="entry_title"><?php the_title(); ?></h1>
			<?php echo $time; ?>
		</header>
		<?php echo wTheme::part('entry-content'); ?>
	</article>
<?php } else { ?>
	<article class="post">
		<?php if (has_post_thumbnail()) { ?>
			<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(wTheme::prefix('featured')); ?></a>
		<?php } ?>
		<header class="entry_header">
			<h2><a href="<?php the_permalink(); ?>"><?php echo wTheme::truncate(get_the_title(), 50); ?></a></h2>
			<?php echo $time; ?>
		</header>
		<div class="entry_content">
			<?php $more = '&#8230; <a href="'.get_permalink().'">'.wTheme::__('Read more').'</a>'; ?>
			<?php echo wTheme::truncate(wTheme::get_the_excerpt(), 250, $more); ?>
		</div>
	</article>
<?php } ?>