<?php
	$contacts = wThemeSettings::get_option('Contacts');
	ob_start();
	foreach ($contacts as $key=>$value) {
		if ('' === $value || 'email_subject' === $key)
			continue;

		$title = wTheme::__(wThemeSettings::$contacts[$key]);

		if ('skype' === $key)
			$value = "skype:{$value}?call";

		if ('email' === $key) {
			$value = 'mailto:'.$value;
			if ('' !== $contacts['email_subject'])
				$value .= '?subject='.urlencode($contacts['email_subject']);
		}
		if ('phone' === $key || 'phone2' === $key)
			$value = 'tel:'.$value;
		?>
		<li class="<?php echo $key; ?>"><a href="<?php echo $value; ?>" title="<?php echo esc_attr($title); ?>"></a></li>
		<?php
	}
	$out = ob_get_clean();
	if (empty($out))
		return;
?>
<ul class="contact_icons"><?php echo $out; ?></ul>