<?php

class wEvent extends wCustomPostType {

	static $post_type = '';

	function __construct($post_type = '') {
		parent::__construct($post_type);
	}

	function get_labels($singular = '', $plural = '') {
		return parent::get_labels('Event', 'Events');
	}

	function register_post_type($args = array()) {
		parent::register_post_type(
			array(
				'supports' => array('title', 'editor', 'thumbnail', 'page-attributes'),
				'rewrite' => array('slug' => 'event', 'with_front' => false),
			)
		);
	}

	function action__add_meta_boxes($post) {
		parent::action__add_meta_boxes($post);
		add_meta_box(wTheme::prefix('additional_fields'), wTheme::__('Additional fields'), array($this, 'meta_box_additional_fields'), $this->post_type(), 'side', 'low');
	}

	function meta_box_additional_fields($post) {
		$meta_key = wTheme::prefix('additional_fields');
		$this->nonce_field($meta_key);
		$data = self::get_all_meta($post->ID);
		?>
		<p>
			<label for="<?php $this->field_id('start_date', $meta_key); ?>"><?php wTheme::_e("Start date & time"); ?></label><br />
			<input type="text" name="<?php $this->field_name('start_date', $meta_key); ?>" value="<?php echo esc_attr(@$data['start_date']); ?>" id="<?php $this->field_id('start_date', $meta_key); ?>" class="datetimepicker" autocomplete="off" maxlength="16" />
		</p>
		<p>
			<label for="<?php $this->field_id('end_date', $meta_key); ?>"><?php wTheme::_e("End date & time"); ?></label><br />
			<input type="text" name="<?php $this->field_name('end_date', $meta_key); ?>" value="<?php echo esc_attr(@$data['end_date']); ?>" id="<?php $this->field_id('end_date', $meta_key); ?>" class="datetimepicker" autocomplete="off" maxlength="16" />
		</p>
		<p>
			<label for="<?php $this->field_id('address', $meta_key); ?>"><?php wTheme::_e('Address'); ?></label><br />
			<input type="text" name="<?php $this->field_name('address', $meta_key); ?>" value="<?php echo esc_attr(@$data['address']); ?>" id="<?php $this->field_id('address', $meta_key); ?>" />
		</p>
		<p>
			<label for="<?php $this->field_id('zip', $meta_key); ?>"><?php wTheme::_e('Zip code'); ?></label><br />
			<input type="text" name="<?php $this->field_name('zip', $meta_key); ?>" value="<?php echo esc_attr(@$data['zip']); ?>" id="<?php $this->field_id('zip', $meta_key); ?>" class="small-text" />
		</p>
		<p>
			<label for="<?php $this->field_id('city', $meta_key); ?>"><?php wTheme::_e('City'); ?></label><br />
			<input type="text" name="<?php $this->field_name('city', $meta_key); ?>" value="<?php echo esc_attr(@$data['city']); ?>" id="<?php $this->field_id('city', $meta_key); ?>" />
		</p>
		<script>
			jQuery(function () {
				jQuery('.datetimepicker').datepicker();
			});
		</script>
		<?php
	}

	function action__save_post($post_id) {
		$this->save_meta_data($post_id, wTheme::prefix('additional_fields'));
	}

}