<?php
/**
 * Version: 0.0.21
 */
class wTheme {

	static $prefix = 'theme_prefix';

	static $domain = 'theme_domain';

	static $layout_options = array();

	static $layout = 'default';

	static $render_layout = true;

	static $here;

	static $here_short;

	static $admin_dir_uri;

	static $body_classes = array();

	static function construct() {
		$domain = wp_get_theme()->get('TextDomain');
		if (empty($domain))
			$domain = get_option('template');

		self::$domain = self::$prefix = $domain;

		$site_url = get_site_url();
		$urls = array();
		preg_match('#^(.*//.*)(/.*)$#U', $site_url, $urls);
		if (empty($urls))
			$urls = array($site_url.'/', $site_url, '/');

		self::$here = $urls[1].$_SERVER['REQUEST_URI'];
		self::$here_short = $urls[1].parse_url("http://host.domain{$_SERVER['REQUEST_URI']}", PHP_URL_PATH);

		if (is_admin())
			self::$admin_dir_uri = get_template_directory_uri().'/inc/admin';
	}

	static function prefix($text) {
		return self::$prefix.'_'.$text;
	}

	static function remove_prefix($text) {
		$prefix = self::prefix('');
		if (0 === strpos($text, $prefix))
			$text = substr($text, strlen($prefix)).'';

		return $text;
	}

	/**
	 * Return a translated string
	 * @param string $text
	 * @param mixed $args [optional]
	 * @param mixed $_ [optional]
	 * @return string
	 */
	static function __($text, $args = null, $_ = null) {
		$translate = translate($text, self::$domain);
		if (func_num_args() > 1)
			return vsprintf($translate, array_slice(func_get_args(), 1));
		return $translate;
	}

	/**
	 * Output a translated string
	 * @param string $text
	 * @param mixed $args [optional]
	 * @param mixed $_ [optional]
	 */
	static function _e($text, $args = null, $_ = null) {
		echo call_user_func_array(array(__CLASS__, '__'), func_get_args());
	}

	static function pagination($pagination_class = 'pagination', $_wp_query = null, $return = false) {
		global $wp_query;
		$out = '';

		$main_wp_query = $wp_query;
		if (null !== $_wp_query) {
			$GLOBALS['wp_query'] = $_wp_query;
			$wp_query = $_wp_query;
		}

		if ($wp_query->max_num_pages > 1) {
			ob_start();
			?>
			<div class="<?php echo $pagination_class; ?>">
				<?php if (function_exists('wp_pagenavi')) {
					wp_pagenavi();
				} else { ?>
					<?php previous_posts_link(self::__('Previous')); ?>
					<?php next_posts_link(self::__('Next')); ?>
				<?php } ?>
			</div>
			<?php
			$out = ob_get_clean();
		}

		if (null !== $wp_query)
			$GLOBALS['wp_query'] = $main_wp_query;

		if ($return)
			return $out;
		echo $out;
	}

	static function truncate($text, $length = 80, $more = '&#8230;') {
		$length = (int) $length;
		$text = strip_shortcodes($text);
		$text = wp_strip_all_tags($text);
		$text = html_entity_decode($text);
		$charset = get_bloginfo('charset');
		if (mb_strlen($text, $charset) <= $length)
			return htmlentities($text, null, $charset);

		$text = trim(mb_substr($text, 0, $length, $charset));
		$text = htmlentities($text, null, $charset);

		return $text.$more;
	}

	/**
	 * @param $template
	 * @param string $dir
	 * @return WP_Post|false
	 */
	static function get_page_by_template($template, $dir = 'page-templates') {
		$template = empty($dir) ? $template : "{$dir}/{$template}";
		if ('.php' !== substr($template, -4))
			$template .= '.php';

		$args = array('meta_key'=>'_wp_page_template', 'meta_value'=>$template, 'hierarchical'=>0, 'posts_per_page'=>1, 'sort_column'=>'menu_order');
		$pages = get_pages($args);

		return empty($pages) ? false : current($pages);
	}

	static function get_url_by_template($template, $dir = 'page-templates') {
		$url = '#';
		if ($page = self::get_page_by_template($template, $dir))
			$url = get_permalink($page->ID);

		return $url;
	}

	static function get_url_by_slug($slug) {
		$url = '#';
		if ($page = get_page_by_path($slug))
			$url = get_permalink($page->ID);

		return $url;
	}

	static function add_body_class($classes) {
		if (!is_array($classes))
			$classes = array($classes);

		self::$body_classes = array_merge(self::$body_classes, $classes);
	}

	static function part($template_name, $vars = array(), $path = 'parts') {
		if ('' !== $path)
			$template_name = $path.'/'.$template_name;

		do_action("get_template_part_{$template_name}", $template_name, null);
		$template_name .= '.php';
		$_template_file = locate_template(array($template_name));
		if (!file_exists($_template_file))
			return "Template Not Found: {$template_name}";

		if (!empty($vars))
			extract($vars, EXTR_SKIP);

		ob_start();
		require $_template_file;

		return ob_get_clean();
	}

	static function get_the_excerpt() {
		$post_excerpt = get_the_excerpt();
		if ('' === $post_excerpt)
			$post_excerpt = get_the_content();

		return $post_excerpt;
	}

	static function get_the_content($content = null, $wrap = true) {
		if (is_null($content))
			$content = get_the_content();

		if ('' !== $content) {
			$content = apply_filters('the_content', $content);
			if ($wrap)
				$content = '<div class="entry_content_wrap">'.$content.'</div>';
		}

		return $content;
	}

	static function get_media_popup_field($field_name, $attachment_id, $label = false, $args = array()) {
		$defaults = array(
			'wrap_tag' => 'p',
			'before' => '',
			'before_image' => '',
			'id' => '',
			'class' => 'wtheme-media_attachment',
			'image_size' => 'medium',
			'button_set_label' => wTheme::__('Set image'),
			'button_remove_label' => wTheme::__('Remove image'),
			'after' => '',
		);
		$args = wp_parse_args($args, $defaults);
		if ('' === $args['id'])
			$args['id'] = 'wtheme-media_attachment-'.preg_replace('/[^\w]+/i', '-', $field_name);

		wp_enqueue_media();
		wp_enqueue_script(wTheme::prefix('functions'), wTheme::$admin_dir_uri.'/js/functions.js', array('jquery'));
		wp_enqueue_style(wTheme::prefix('style'),  wTheme::$admin_dir_uri.'/style.css');
		ob_start();
		?>
		<<?php echo $args['wrap_tag']; ?> class="<?php echo $args['class']; ?>" id="<?php echo $args['id']; ?>">
			<input type="hidden" name="<?php echo $field_name ?>" value="<?php echo esc_attr($attachment_id); ?>" />
			<?php
				if ('' !== $args['before']) {
					echo $args['before'];
				}
			?>
			<?php if ($label) { ?>
				<label id="<?php echo $args['id']; ?>-label" for="<?php echo $args['id']; ?>-button_set"><?php echo $label; ?></label><br />
			<?php } ?>
			<a class="button button-set" href="#" data-image_size="<?php echo $args['image_size']; ?>" id="<?php echo $args['id']; ?>-button_set"><?php echo $args['button_set_label']; ?></a>
			<a class="button button-remove" href="#" style="<?php if (!$attachment_id) echo 'display:none;'; ?>" id="<?php echo $args['id']; ?>-button_remove"><?php echo $args['button_remove_label']; ?></a>
			<?php
				if ('' !== $args['before_image']) {
					echo $args['before_image'];
				}
			?>
			<span class="img-wrap">
			<?php
				if ($attachment_id && get_post($attachment_id)) {
					if (wp_attachment_is_image($attachment_id)) {
						echo wp_get_attachment_image($attachment_id, $args['image_size']);
					} else {
						$mime_type = get_post_mime_type($attachment_id);
						$icon_src = wp_mime_type_icon($mime_type);
						echo wp_get_attachment_image($attachment_id, $args['image_size'], $icon_src);
						echo '<span class="filename">'.basename(get_attached_file($attachment_id)).'</span>';
					}
				}
			?>
			</span>
			<?php
				if ('' !== $args['after']) {
					echo $args['after'];
				}
			?>
		</<?php echo $args['wrap_tag']; ?>>
		<script>
			jQuery(function() {
				var $button_set = jQuery('#<?php echo $args['id']; ?>-button_set');
				wtheme_media_popup_attachment_button($button_set, jQuery('#<?php echo $args['id']; ?>-button_remove'));
				jQuery('#<?php echo $args['id']; ?>-label').click(function () { $button_set.click(); });
			});
		</script>
		<?php

		return ob_get_clean();
	}

	/**
	 * Automatic register a new image size with retina 2x size.
	 */
	static function add_image_size($name, $width = 0, $height = 0, $crop = false) {
		$default_name = wTheme::prefix($name);
		add_image_size($default_name, $width, $height, $crop);

		$retina_name = $default_name.'_2x';
		if (9999 !== $width)
			$width *= 2;
		if (9999 !== $height)
			$height *= 2;
		add_image_size($retina_name, $width, $height, $crop);
	}

	static function get_share_url($type, $url = null, $text = '') {
		if (!$url)
			$url = get_permalink();
		$url = urlencode($url);
		$text = urlencode($text);
		switch ($type) {
			case 'facebook':
				$url = "https://www.facebook.com/sharer/sharer.php?u={$url}";
				if('' != $text)
					$url .= "&amp;t={$text}";
				break;
			case 'twitter':
				$url = "https://twitter.com/share?url={$url}"; //&via=TWITTER-HANDLE
				if('' != $text)
					$url .= "&amp;text={$text}";
				break;
			case 'google_plus':
				$url = "https://plus.google.com/share?url={$url}";
				break;
			case 'linkedin':
				$url = "https://www.linkedin.com/shareArticle?mini=true&amp;url={$url}";
				if('' != $text)
					$url .= "&amp;summary={$text}";
				break;
			case 'pinterest':
				$url = "https://www.pinterest.com/pin/create/button/?url={$url}";
				if('' != $text)
					$url .= "&amp;description={$text}";
				break;
		}

		return $url;
	}

}
wTheme::construct();