<?php
/**
 * Version: 0.1.0
 */
class wSlider extends wCustomPostType {

	static $post_type;

	public function __construct($args) {
		$theme_support = get_option(wTheme::prefix('theme_support'));
		$theme_slider = @$theme_support['Slider']['settings'];
		if (empty($theme_slider))
			return;

		parent::__construct($args);
	}

	function add_hooks() {
		parent::add_hooks();
		add_action('after_setup_theme', array(__CLASS__, 'action__after_setup_theme'));
		add_action('wp_enqueue_scripts', array(__CLASS__, 'action__wp_enqueue_scripts'));
	}

	static function action__after_setup_theme() {
		$option = wThemeSettings::get_option('Slider.settings');
		if(!empty($option['width']) && !empty($option['height'])) {
			$crop = false;
			if (!empty($option['crop']))
				$crop = true;

			add_image_size(wTheme::prefix('slide'), $option['width'], $option['height'], $crop);
		}
	}

	static function action__wp_enqueue_scripts() {
		$template_directory_uri = get_template_directory_uri();
		wp_register_script(wTheme::prefix('cycle'), $template_directory_uri.'/js/cycle2/jquery.cycle2.min.js', array('jquery'));
		wp_register_script(wTheme::prefix('cycle_swipe'), $template_directory_uri.'/js/cycle2/jquery.cycle2.swipe.min.js', array('jquery'));
		wp_register_script(wTheme::prefix('cycle_scroll_vert'), $template_directory_uri.'/js/cycle2/jquery.cycle2.scrollVert.min.js', array('jquery'));
		wp_register_script(wTheme::prefix('cycle_tile'), $template_directory_uri.'/js/cycle2/jquery.cycle2.tile.min.js', array('jquery'));
	}

	function get_labels($singular = '', $plural = '') {
		return parent::get_labels('Slide', 'Slides');
	}

	function register_post_type($args = array()) {
		parent::register_post_type(
			array(
				'public' => false,
				'supports' => array('title', 'thumbnail', 'page-attributes'),
			)
		);
	}

	function action__add_meta_boxes($post) {
		parent::action__add_meta_boxes($post);
		add_meta_box(wTheme::prefix('slide_fields'), wTheme::__('Slide fields'), array($this, 'meta_box_slide_fields'), $this->post_type(), 'normal', 'high');
	}

	function meta_box_slide_fields($post) {
		$meta_key = wTheme::prefix('slide_fields');
		$this->nonce_field($meta_key);
		$data = self::get_all_meta($post->ID);
		$option = wThemeSettings::get_option('Slider')['settings'];
		wp_enqueue_script('wp-color-picker');
		wp_enqueue_style('wp-color-picker');
		?>
		<p>
			<?php $field = 'slide_title'; ?>
			<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Slide title'); ?></label><br />
			<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" class="large-text" />
		</p>
		<p>
			<?php $field = 'title_color'; $value = @$data[$field]; ?>
			<label for="<?php $this->field_id($field, $meta_key); ?>"><?php _e('Title color'); ?></label><br />
			<input class="middle-text color_picker" id="<?php $this->field_id($field, $meta_key); ?>" name="<?php $this->field_name($field, $meta_key); ?>" type="text" value="<?php echo esc_attr($value); ?>" />
		</p>
		<p>
			<?php $field = 'slide_text'; $value = @$data[$field]; ?>
			<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Slide text'); ?></label><br />
			<textarea name="<?php $this->field_name($field, $meta_key); ?>" id="<?php $this->field_id($field, $meta_key); ?>" rows="5" cols="80" class="widefat"><?php echo esc_textarea($value); ?></textarea>
		</p>
		<p>
			<?php $field = 'url'; ?>
			<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('URL'); ?></label><br />
			<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" class="large-text" />
		</p>
		<p>
			<?php $field = 'is_open_in_new_tab'; ?>
			<input type="hidden" name="<?php $this->field_name($field, $meta_key); ?>" value="0" />
			<label><input type="checkbox" name="<?php $this->field_name($field, $meta_key); ?>" value="1" <?php checked(@$data[$field]); ?> /> <?php wTheme::_e('Open in new tab'); ?></label>
		</p>
		<p>
			<?php $field = 'read_more_text'; ?>
			<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Read more text label'); ?></label><br />
			<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" class="large-text" />
		</p>
		<p>
			<?php $field = 'class'; ?>
			<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('CSS class'); ?></label><br />
			<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" class="large-text" />
		</p>
		<?php if (!empty($option['show_navigation_menu'])) { ?>
			<p>
				<?php $field = 'navigation_menu_title'; ?>
				<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Navigation menu title'); ?></label><br />
				<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" class="large-text" />
			</p>
			<p>
				<?php $field = 'navigation_class'; ?>
				<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Navigation CSS class'); ?></label><br />
				<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" class="large-text" />
			</p>
		<?php } ?>
		<p>
			<?php $field = 'slide_template'; ?>
			<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Slide template'); ?></label><br />
			<select name="<?php $this->field_name($field, $meta_key); ?>" id="<?php $this->field_id($field, $meta_key); ?>">
				<option value="left" <?php selected(@$data[$field], 'left'); ?>><?php wTheme::_e('Left text'); ?></option>
				<option value="right" <?php selected(@$data[$field], 'right'); ?>><?php wTheme::_e('Right text'); ?></option>
			</select>
		</p>
		<script>
			jQuery(function() {
				jQuery('.color_picker').each(function(){
					jQuery(this).wpColorPicker();
				});
			});
		</script>
		<?php
	}

	function action__save_post($post_id) {
		$this->save_meta_data($post_id, wTheme::prefix('slide_fields'));
	}

	static function wp_query($args = array(), $settings = array()) {
		$defaults = array(
			'orderby' => array('menu_order' => 'ASC', 'ID' => 'ASC'),
		);

		$args = wp_parse_args($args, $defaults);
		return parent::wp_query($args, $settings);
	}
}