<?php

function wtheme_action__after_setup_theme() {

	wp_get_theme()->load_textdomain();

	add_theme_support('html5', array('search-form', 'comment-form', 'comment-list'));

	register_nav_menu('main_menu', wTheme::__('Main Menu'));

	add_theme_support('post-thumbnails');

	//wTheme::add_image_size('page_thumb', 100, 80, true);
	wTheme::add_image_size('inspiration_category_thumb', 405, 250, true);
	wTheme::add_image_size('post_thumb_widget', 90, 60, true);
}
add_action('after_setup_theme', 'wtheme_action__after_setup_theme');

function wtheme_scripts_styles() {
	$template_directory_uri = get_template_directory_uri();
	$js_directory_uri = "{$template_directory_uri}/js/";
	$suffix = SCRIPT_DEBUG ? '' : '.min';

	$main_style = is_front_page() ? 'home.css' : 'style.css';
	wp_enqueue_style(wTheme::prefix('main-style'), $template_directory_uri.'/css/'.$main_style);
	wp_enqueue_style(wTheme::prefix('prettyPhoto_style'), $js_directory_uri . "prettyPhoto/prettyPhoto{$suffix}.css");

	wp_enqueue_script('jquery');
	wp_enqueue_script(wTheme::prefix('prettyPhoto'), $js_directory_uri . "prettyPhoto/jquery.prettyPhoto{$suffix}.js", array('jquery'));
	wp_enqueue_script(wTheme::prefix('functions'), $js_directory_uri . "functions{$suffix}.js", array('jquery'));
	wp_enqueue_script(wTheme::prefix('anime'), $js_directory_uri . "anime.js", array('jquery'));
}

function wtheme_action__widgets_init() {
	register_widget('wTheme_Widget_Children_Pages');
	register_widget('wTheme_Widget_Google_Map');
	register_widget('wTheme_Widget_Featured_Text');
	register_widget('wTheme_Widget_Latest_Events');
	register_widget('wTheme_Widget_Recent_Post');
	register_widget('wTheme_Widget_Footer_Content');

	if (defined('ICL_SITEPRESS_VERSION') && defined('ICL_PLUGIN_INACTIVE') && !ICL_PLUGIN_INACTIVE)
		register_widget('wTheme_Widget_Featured_Text_Icl');

	$before = '<div class="sidebar %s" id="%s" itemscope itemtype="http://schema.org/WPSideBar">';
	//wSidebar::register(array('name'=>wTheme::__('Left sidebar'), 'id'=>'left', 'before'=>sprintf($before, '%s', 'left_sidebar')));
	wSidebar::register(array('name'=>wTheme::__('Home top sidebar'), 'id'=>'home_top', 'before'=>sprintf($before, '%s', 'home_top_sidebar')));
	wSidebar::register(array('name'=>wTheme::__('Home bottom sidebar'), 'id'=>'home_bottom', 'before'=>sprintf($before, '%s', 'home_bottom_sidebar')));
	wSidebar::register(array('name'=>wTheme::__('Footer top sidebar'), 'id'=>'footer_top', 'before'=>sprintf($before, '%s', 'footer_top_sidebar')));
	wSidebar::register(array('name'=>wTheme::__('Footer sidebar'), 'id'=>'footer', 'before'=>sprintf($before, '%s', 'footer_sidebar'), 'before_title'=>'<h4 class="widget_title">', 'after_title'=>'</h4>'));
}
add_action('widgets_init', 'wtheme_action__widgets_init');

function wtheme_filter__wp_title($title, $sep) {
	global $paged, $page;

	if (is_feed())
		return $title;

	// Add the site name.
	$title .= get_bloginfo('name');

	// Add the site description for the home/front page.
	$site_description = get_bloginfo('description', 'display');
	if ($site_description && (is_home() || is_front_page()))
		$title = "$title $sep $site_description";

	// Add a page number if necessary.
	if ($paged >= 2 || $page >= 2)
		$title = "$title $sep ".sprintf(wTheme::__('Page %s'), max($paged, $page));

	return $title;
}
add_filter('wp_title', 'wtheme_filter__wp_title', 10, 2);

function wtheme_filter__img_caption_shortcode($nothing, $attr, $content = null) {
	extract(shortcode_atts(array('id'=>'', 'align'=>'alignnone', 'width'=>'', 'caption'=>''), $attr));

	if (1 > (int) $width || empty($caption))
		return $content;

	if ($id) $id = 'id="'.esc_attr($id).'" ';

	return '<dl '.$id.'class="wp_caption '.esc_attr($align).'" style="width: '.((int) $width).'px"><dt>'
			.do_shortcode($content).'</dt><dd class="wp_caption_text">'.$caption.'</dd></dl>';
}
add_filter('img_caption_shortcode', 'wtheme_filter__img_caption_shortcode', 10, 3);

function wtheme_regenerate_attachment_thumbnails($attachment_id) {
	if (!wp_attachment_is_image($attachment_id))
		return;

	if (!function_exists('media_handle_sideload')) {
		require_once(ABSPATH.'wp-admin'.'/includes/image.php');
		require_once(ABSPATH.'wp-admin'.'/includes/file.php');
		require_once(ABSPATH.'wp-admin'.'/includes/media.php');
	}

	$file_path = get_attached_file($attachment_id, true);
	$metadata = wp_generate_attachment_metadata($attachment_id, $file_path);

	if (!is_wp_error($metadata) && !empty($metadata))
		wp_update_attachment_metadata($attachment_id, $metadata);
}

function wtheme_filter__wp_get_attachment_link($link) {
	return str_replace('<a ', '<a rel="prettyPhoto['.wTheme::prefix('gallery').']" ', $link);
}
add_filter('wp_get_attachment_link', 'wtheme_filter__wp_get_attachment_link');

function wtheme_filter__body_class($classes) {
	if (is_front_page()) {
		if ($index = array_search('page', $classes))
			unset($classes[$index]);
	}
	if (is_page() && is_page_template()) {
		$page_template = get_page_template_slug(get_queried_object_id());
		$classes[] = 'page-'.sanitize_html_class(str_replace('.', '-', basename($page_template, '.php')));
	}
	if (is_single()) {
		$item = get_queried_object();
		$classes[] = 'single-'.wTheme::remove_prefix($item->post_type);
	}
	if (wTheme::$layout)
		$classes[] = sanitize_html_class(str_replace('.', '-', 'layout-'.wTheme::$layout));

	$classes = array_merge($classes, wTheme::$body_classes);

	return $classes;
}
add_filter('body_class', 'wtheme_filter__body_class');

function wtheme_filter__previous_posts_link_attributes($attr) {
	return 'class="previous"';
}
add_filter('previous_posts_link_attributes', 'wtheme_filter__previous_posts_link_attributes');

function wtheme_filter__next_posts_link_attributes($attr) {
	return 'class="next"';
}
add_filter('next_posts_link_attributes', 'wtheme_filter__next_posts_link_attributes');

function wtheme_filter__wpcf7_form_class_attr($class) {
	$search = 'use-floating-validation-tip';
	if (false ===strpos($class, $search))
		$class .= ' '.$search;
	return $class;
}
add_filter('wpcf7_form_class_attr', 'wtheme_filter__wpcf7_form_class_attr');

// Fix with insert media to editor and don't auto bind to post
function wtheme_action__wp_ajax__send_attachment_to_editor() {
	$attachment = wp_unslash($_POST['attachment']);
	$post = get_post(intval($attachment['id']));
	if ($post && isset($_POST['post_id'])) {
		$_POST['post_id'] = $post->post_parent;
	}
}
add_action('wp_ajax_send-attachment-to-editor', 'wtheme_action__wp_ajax__send_attachment_to_editor', 0);

function wtheme_shortcode__read_more($atts, $content='') {
	$a = shortcode_atts(array('button_label'=>wTheme::__('Read more')), $atts);

	if (false !== strpos($content, '[split]')) {
		$content_pieces = explode('[split]', $content);
		ob_start();
		?>
		<div class="shortcode__read_more">
			<div class="shortcode__visible_content gradient"><?php echo wpautop(trim(do_shortcode($content_pieces[0]))); ?></div>
			<div class="shortcode__hidden_content" style="display: none;"><?php echo wpautop(trim(do_shortcode($content_pieces[1]))); ?></div>
			<div class="shortcode__read_more_wrap">
				<a href="#" class="shortcode__read_more_button"><?php echo $a['button_label']; ?></a>
			</div>
		</div>
		<?php
		return ob_get_clean();
	}
	return $content;
}
add_shortcode('read_more', 'wtheme_shortcode__read_more');

function wtheme_shortcode__hidecontent($atts, $content='') {
	$key = wTheme::prefix('shortcode_hidecontent');
	$GLOBALS[$key] = isset($GLOBALS[$key]) ? $GLOBALS[$key] + 1 : 1;
	$content = wpautop(trim(do_shortcode($content)));
	$out = ' <a href="#shortcode_hidecontent_'.$GLOBALS[$key].'" class="shortcode_hidecontent">'.wTheme::__("Read more").'</a>';
	$out .= ' <a href="#shortcode_hidecontent_'.$GLOBALS[$key].'" class="shortcode_showcontent" style="display: none;">'.wTheme::__("Hide content").'</a>';
	return $out.'<div class="shortcode_hidecontent_'.$GLOBALS[$key].'" style="display: none;">'.$content.'</div>';
}
add_shortcode('hidecontent', 'wtheme_shortcode__hidecontent');

function wtheme_shortcode__question($atts, $content='') {
	return '<div class="shortcode_question">'.do_shortcode($content).'</div>';
}
add_shortcode('question', 'wtheme_shortcode__question');

function wtheme_shortcode__answer($atts, $content='') {
	$style = isset($atts['expand']) ? '' : 'style="display: none;"';
	$content = wpautop(trim(do_shortcode($content)));
	return '<div class="shortcode_answer" '.$style.'>'.$content.'</div>';
}
add_shortcode('answer', 'wtheme_shortcode__answer');

function wtheme_filter__the_content__shortcode_paragraph_fix($content) {
	return strtr($content, array('<p>['=>'[', ']</p>'=>']', ']<br />'=>']'));
}
add_filter('the_content', 'wtheme_filter__the_content__shortcode_paragraph_fix');

function wtheme_shortcode__split($atts, $content) {
	return '[split]';
}
add_shortcode('split', 'wtheme_shortcode__split');

function wtheme_render_columns($content, $columns) {
	remove_filter('the_content', 'wtheme_filter__the_content__cols', 1);
	remove_filter('the_content', 'wtheme_media_wrapper', 9);
	add_filter('the_content', 'wtheme_filter__the_content', 11);
	if (false !== strpos($content, '[split]')) {
		$columns_content = '';
		foreach (explode('[split]', $content) as $c)
			$columns_content .= wTheme::get_the_content($c, false);
		add_filter('the_content', 'wtheme_filter__the_content__cols', 1);
		remove_filter('the_content', 'wtheme_filter__the_content', 11);
		add_filter('the_content', 'wtheme_media_wrapper', 9);
		return '<div class="columns_'.$columns.' clear">'.$columns_content.'</div>';
	}

	add_filter('the_content', 'wtheme_filter__the_content__cols', 1);
	remove_filter('the_content', 'wtheme_filter__the_content', 11);
	add_filter('the_content', 'wtheme_media_wrapper', 9);
	$content = wTheme::get_the_content($content, false);
	return '<div class="columns_'.$columns.' entry_content clear">'.$content.'</div>';
}

function wtheme_shortcode__column2($atts, $content) {
	return wtheme_render_columns($content, 2);
}
add_shortcode('column2', 'wtheme_shortcode__column2');

function wtheme_shortcode__column3($atts, $content) {
	return wtheme_render_columns($content, 3);
}
add_shortcode('column3', 'wtheme_shortcode__column3');

function wtheme_shortcode__column4($atts, $content) {
	return wtheme_render_columns($content, 4);
}
add_shortcode('column4', 'wtheme_shortcode__column4');

function wtheme_filter__the_content($content) {
	return '<div class="entry_content clear">'.$content.'</div>';
}

function wtheme_filter__the_content__cols($content) {
	for ($i=2; $i<=5; $i++)
		$content = str_replace(array("[column{$i}]", "[/column{$i}]"), array("</div>[column{$i}]", "[/column{$i}]".'<div class="entry_content clear">'."\n\r"), $content);
	return '<div class="entry_content clear">'."\n\r".$content."\n\r".'</div>';
}
add_filter('the_content', 'wtheme_filter__the_content__cols', 1);

function wtheme_filter__the_content__clean($content) {
	return str_replace('<div class="entry_content clear">
</div>', '', $content);
}
add_filter('the_content', 'wtheme_filter__the_content__clean', 11);

function wtheme_action__wp_head__ie_js_includes() {
	?>
	<!--[if lt IE 9]>
	<script src="<?php echo get_template_directory_uri(); ?>/js/html5.min.js" type="text/javascript"></script>
	<![endif]-->
	<?php
	if (!is_singular())
		return;

	$content = get_the_content();
	$has_shortcode = false;
	for ($i=2; $i<=5; $i++)
		if (has_shortcode($content, 'column'.$i))
			$has_shortcode = true;

	if (!$has_shortcode)
		return false;

	?>
	<!--[if lt IE 10]>
	<script src="<?php echo get_template_directory_uri(); ?>/js/css3-multi-column.min.js" type="text/javascript"></script>
	<![endif]-->
	<?php
}
add_action('wp_head' , 'wtheme_action__wp_head__ie_js_includes');

function wtheme_media_wrapper($content) {
	preg_match_all('~<iframe.*</iframe>|<embed.*</embed>|<object.*</object>~', $content, $matches);

	foreach ($matches[0] as $i=>$match) {
		$replace = "[%REPLACE-MEDIA-{$i}%]";
		if (strpos($content, $match) !== false)
			$content = substr_replace($content, $replace, strpos($content, $match), strlen($match));
	}

	foreach ($matches[0] as $i=>$match) {
		$wrap = '<div class="media_wrap">'.$match.'</div>';
		preg_match('/ *width *= *["\']?([^"\']*)/i', $match, $width);
		if (!empty($width[1])) {
			$max_width = trim($width[1]);
			if ('%' !== substr($max_width, -1))
				$max_width .= 'px';

			$wrap = '<div style="max-width: '.$max_width.';">'.$wrap.'</div>';
		}

		$replace = "[%REPLACE-MEDIA-{$i}%]";
		$content = str_replace($replace, $wrap, $content);
	}
	return $content;
}
add_filter('the_content', 'wtheme_media_wrapper', 9);
add_filter('widget_text', 'wtheme_media_wrapper', 9);

function wtheme_shortcode__general_button($atts, $content = null) {
	extract(shortcode_atts(array('url'=>'#', 'external'=>false), $atts));
	$external = $external ? 'onclick="this.target=\'_blank\'"' : '';
	return '<a class="general_button" href="'.$url.'" '.$external.'>'.$content.'</a>';
}
add_shortcode('button', 'wtheme_shortcode__general_button');
add_filter('widget_text', 'do_shortcode');
//todo add shortcode 'read more button', 'popup'

function wtheme_filter__widget_title__allowed_tags($title) {
	$title = str_replace(array('[', ']'), array('<', '>'), $title);
	$title = strip_tags(html_entity_decode($title), '<a><br><span>');
	return $title;
}
add_filter('widget_title', 'wtheme_filter__widget_title__allowed_tags');

function wtheme_action__after_switch_theme() {
	if (get_page_by_path('sample-page')) {
		$page = get_page_by_path('sample-page');
		wp_update_post(array('ID'=>$page->ID, 'post_content'=>wTheme::part('sample-page')));
	} else {
		$new_post = array(
			'post_content' => wTheme::part('sample-page'),
			'post_title' => 'Sample page',
			'post_type' => 'page',
			'post_status' => 'publish'
		);
		wp_insert_post($new_post, false);
	}

	if (!get_page_by_path('contact')) {
		$new_post = array(
			'post_content' => '[contact-form-7 title="Contact form 1"]',
			'post_title' => 'Contact',
			'post_type' => 'page',
			'post_status' => 'publish'
		);
		wp_insert_post($new_post, false);
	}
}
add_action('after_switch_theme', 'wtheme_action__after_switch_theme');

function wtheme_action__admin_notices__hide_update_notice() {
	remove_action('admin_notices', 'update_nag', 3);
	remove_action('network_admin_notices', 'update_nag', 3);
}
add_action('admin_notices', 'wtheme_action__admin_notices__hide_update_notice', 1);

function wtheme_filter__image_size_names_choose($sizes) {
	$new_sizes = array();
	$added_sizes = get_intermediate_image_sizes();
	foreach ($added_sizes as $key=>$size_name) {
		if (0 === strpos($size_name, wTheme::prefix('')) && '_2x' == substr($size_name, -3))
			continue;

		$label = wTheme::remove_prefix($size_name);
		$label = str_replace(array('_', '-'), ' ', $label);
		$new_sizes[$size_name] = ucfirst($label);
	}

	return array_merge($sizes, $new_sizes);
}
add_filter('image_size_names_choose', 'wtheme_filter__image_size_names_choose', 11, 1);

function wtheme_filter__wp_calculate_image_srcset($sources, $size_array) {
	list($width, $height) = $size_array;

	if (!isset($sources[$width]))
		return $sources;

	$new_sources = array();
	$new_sources[$width] = $sources[$width];
	$retina_width = $width * 2;

	if (isset($sources[$retina_width]))
		$new_sources[$retina_width] = $sources[$retina_width];

	if (1 == count($new_sources)) {
		$max_width = $width;
		foreach ($sources as $w=>$source)
			if ($w > $max_width)
				$max_width = $w;
		$new_sources[$max_width] = $sources[$max_width];
	}

	return $new_sources;
}
add_filter('wp_calculate_image_srcset', 'wtheme_filter__wp_calculate_image_srcset', 99, 2);

function wtheme_filter__mime_types($mime_types) {
	$mime_types['svg'] = 'image/svg+xml';
	return $mime_types;
}
add_filter('mime_types', 'wtheme_filter__mime_types');

function wtheme_filter__wp_update_attachment_metadata__svg_size($data, $id) {
	$attachment = get_post($id); // Filter makes sure that the post is an attachment

	//If the attachment is an svg
	if ($attachment->post_mime_type === 'image/svg+xml') {
		//If the svg metadata are empty or the width is empty or the height is empty
		//then get the attributes from xml.
		if (empty($data) || empty($data['width']) || empty($data['height'])) {
			$xml = simplexml_load_file(get_attached_file($id));
			if (false !== $xml) {
				$attr = $xml->attributes();
				$viewbox = explode(' ', $attr->viewBox);
				$data['width'] = isset($attr->width) && preg_match('/\d+/', $attr->width, $value) ? (int) $value[0] : (count($viewbox) == 4 ? (int) $viewbox[2] : null);
				$data['height'] = isset($attr->height) && preg_match('/\d+/', $attr->height, $value) ? (int) $value[0] : (count($viewbox) == 4 ? (int) $viewbox[3] : null);
			}
		}
	}
	return $data;
}
add_filter('wp_update_attachment_metadata', 'wtheme_filter__wp_update_attachment_metadata__svg_size', 10, 2);

function wtheme_filter__rest_attachment_query__skip_svg_regeneration($args, $request) {
	//Exclude svg files from Regenerate Thumbnails
	if (!empty( $request['is_regeneratable']) && !empty($args['post_mime_type']))
		$args['post_mime_type'] = array_diff($args['post_mime_type'], array('image/svg+xml'));

	return $args;
}
add_filter('rest_attachment_query', 'wtheme_filter__rest_attachment_query__skip_svg_regeneration', 99, 2);

function wtheme_filter__tiny_mce_before_init($init) {
	$init['valid_elements'] = '*[*]';
	$init['extended_valid_elements'] = '*[*]';

	return $init;
}
add_filter('tiny_mce_before_init', 'wtheme_filter__tiny_mce_before_init');

function wtheme_filter__template_include($file_template) {
	wtheme_scripts_styles();

	if (is_front_page() && is_page_template('default')) {
		wTheme::$layout = null;
	} elseif (is_page()) {
		$template = get_post_meta(get_queried_object_id(), '_wp_page_template', true);
		$templates = wSidebar::get_page_templates_layouts();
		if (isset($templates[$template]))
			wTheme::$layout = $templates[$template];
	} elseif (is_404()) {
		wTheme::$layout = 'full-width';
	}

	ob_start();
	require $file_template;
	$content_for_layout = ob_get_clean();

	if (false === wTheme::$render_layout)
		echo $content_for_layout;
	else
		echo wTheme::part('layout', compact('content_for_layout'), '');

	exit(0);
}
add_filter('template_include', 'wtheme_filter__template_include', 999);

require_once get_template_directory().'/inc/init.php';
