<?php
/**
 * Plugin Name: WebCoders EU cookie law promt
 * Plugin URI: http://webcoders.dk/
 * Description: Plugin that enable visitors to see the EU cookie law promt when entering the site for the first time.
 * Version: 1.1.0
 * Author: WebCoders.dk
 * Author URI: http://webcoders.dk/
 * License: You can read more about our general license agreement on http://webcoders.dk/terms-and-conditions/
 */

//TODO: rename prefixes on WebCoders_

require_once plugin_dir_path(__FILE__).'wPlugin.php';

if (!class_exists('PRO_EUCLP_Cookie')) {
class PRO_EUCLP_wView extends PRO_EUCLP_wPlugin {
	/**
	 * Contains variables to be handed to the view.
	 *
	 * @var array
	 */
	var $viewVars = array();

	var $output = '';

	function output() {
		echo $this->output;
	}

	function render($action) {
		$this->output = '';
		if ($viewFileName = $this->_getViewFileName($action)) {
			extract($this->viewVars, EXTR_SKIP);
			ob_start();
			include $viewFileName;
			$this->output = ob_get_clean();
		}
		return $this->output;
	}

	function _getViewFileName($name = null) {
		$file = self::$plugin_dir_path.'/templates/'.$name.'.ctp';
		if(file_exists($file))
			return $file;

		wp_die('Missing view '.$name);
	}

	function set($one, $two = null) {
		if (is_array($one)) {
			if (is_array($two)) {
				$data = array_combine($one, $two);
			} else {
				$data = $one;
			}
		} else {
			$data = array($one => $two);
		}
		$this->viewVars = $data + $this->viewVars;
	}
}

class PRO_EUCLP_Cookie extends PRO_EUCLP_wPlugin {

	var $db_version = 1;

	var $View = null;

	var $settings_key = '';

	var $cookie_key = '';

	function __construct() {
		parent::__construct();
		$this->View = new PRO_EUCLP_wView();
		$this->settings_key = self::prefix('settings');
		$this->cookie_key = self::prefix('cookies_box_state');
	}

	function _hooks() {
		parent::_hooks();
		register_activation_hook(__FILE__, array($this, 'activation'));
		add_filter('plugin_action_links', array($this, 'filter_plugin_action_links'), 10, 2);
		add_action('admin_menu', array($this, 'admin_menu'));
		add_action('wp_ajax_'.self::prefix('load_styles'), array($this, 'load_styles'));
		add_action('wp_ajax_nopriv_'.self::prefix('load_styles'), array($this, 'load_styles'));
		add_action('wp_enqueue_scripts', array($this, 'action_wp_enqueue_scripts'));
		add_action('wp_footer', array($this, 'action_wp_footer'));
	}

	function filter_plugin_action_links($links, $file) {
		if ($file != plugin_basename(__FILE__) || !current_user_can('administrator'))
			return $links;

		$setting_url = add_query_arg('page', self::prefix('settings'), admin_url('admin.php'));
		$setting_link = '<a href="'.esc_attr($setting_url).'">'.self::__('Settings').'</a>';
		array_unshift($links, $setting_link);
		return $links;
	}

	function admin_menu() {
		$view = $this->View;

		$hookname = add_menu_page(self::__('Pro EU cookie'), self::__('Pro EU cookie'), 'administrator', self::prefix('settings'), array($view, 'output'), self::$plugin_dir_url.'/img/icon.png');
		add_action("load-$hookname", array($this, 'settings'));
	}

	function _icl_get_current_language() {
		global $sitepress;
		$current_language = $sitepress->get_current_language();
		if ('all' == $current_language)
			$current_language = $sitepress->get_default_language();
		return $current_language;
	}

	function get_settings_key() {
		$settings_key = $this->settings_key;
		if (defined('ICL_LANGUAGE_CODE')) {
			$current_language = $this->_icl_get_current_language();
			$settings_key = $settings_key.'_'.$current_language;
		}
		return $settings_key;
	}

	function get_settings() {
		$settings_key = $this->get_settings_key();
		return get_option($settings_key);
	}

	function save_settings($data, $settings_key = false) {
		if (!$settings_key)
			$settings_key = $this->get_settings_key();
		if (defined('ICL_LANGUAGE_CODE')) {
			global $sitepress;
			$current_language = $this->_icl_get_current_language();
			$default_language = $sitepress->get_default_language();
			if ($default_language === $current_language)
				update_option($this->settings_key, $data);
		}
		return update_option($settings_key, $data);
	}

	function settings() {
		$saved = false;
		if (!empty($_POST['data'])) {
			$data = stripslashes_deep($_POST['data']);
			if(isset($data['reset_settings']))
				$data = $this->get_default_settings();
			$saved = $this->save_settings($data);
		} else {
			$data = $this->get_settings();
		}

		$this->View->set(compact('data', 'saved'));
		$this->View->render('settings');
	}

	function get_default_settings() {
		return array(
			'title' => self::__("We use cookies!"),
			'content' => self::__("At this site we use cookies to enhance the user experience and for tracking purposes. By using this site you accept the use of cookies.

Read more about cookies here."),
			'read_more_url' => get_home_url('/').'/cookies',
			'button_accept_label' => self::__("Accept"),
			'button_leave_site_label' => self::__("Leave site"),
			//todo update key to button_leave_site_url
			'leave_site_url' => 'http://google.com/',
			'position' => array(
				'horizontal' => 'left',
				'vertical' => 'bottom',
			),
			'custom_css' => @file_get_contents(self::$plugin_dir_path.'/css/default_styles.css'),
		);
	}

	function set_default_settings() {
		$settings = $this->get_settings();
		if(!empty($settings))
			return $settings;

		$default_settings = $this->get_default_settings();
		if (defined('ICL_LANGUAGE_CODE')) {
			$languages = icl_get_languages('skip_missing=1');
			foreach ($languages as $lang) {
				$settings_key = $this->settings_key.'_'.$lang['language_code'];
				$this->save_settings($default_settings, $settings_key);
			}
		} else {
			$this->save_settings($default_settings);
		}

		return $default_settings;
	}

	function upgrade() {
		$current_db_version = get_option(self::prefix('db_version'));
		if (false === $current_db_version) {
			add_option(self::prefix('db_version'), $this->db_version);
		} else if ($this->db_version > $current_db_version) {
			update_option(self::prefix('db_version'), $this->db_version);
		}
	}

	function activation() {
		$this->set_default_settings();
		$this->upgrade();
	}

	function load_styles() {
		$data = $this->get_settings();
		if (empty($data['custom_css']))
			return;

		header('Content-Type: text/css');
		?>
		<?php echo @$data['custom_css']; ?>
		#pro_euclp_cookies_box {
			<?php echo @$data['position']['horizontal']; ?>: -210px;
			<?php echo @$data['position']['vertical']; ?>: 10px;
		}
		<?php
		die;
	}

	function action_wp_enqueue_scripts() {
		if ($this->is_accept_cookies())
			return;

		wp_enqueue_style(self::prefix('main-styles'), add_query_arg('action', self::prefix('load_styles'), admin_url('admin-ajax.php')));
	}

	function action_wp_footer() {
		$this->show_box();
	}

	function show_box() {
		if ($this->is_accept_cookies())
			return;

		wp_enqueue_script('jquery');
		$data = $this->get_settings();
		$cookie_key = $this->cookie_key;
		$this->View->set(compact('data', 'cookie_key'));
		echo $this->View->render('show_box');
	}

	function is_accept_cookies() {
		return isset($_COOKIE[$this->cookie_key]);
	}
}
}

PRO_EUCLP_wPlugin::init('pro_euclp');
$PRO_EUCLP_Cookie = new PRO_EUCLP_Cookie();
